/*
 * Decompiled with CFR 0.152.
 */
package com.getperka.flatpack.client.impl;

import com.getperka.flatpack.FlatPackEntity;
import com.getperka.flatpack.client.FlatPackRequest;
import com.getperka.flatpack.client.StatusCodeException;
import com.getperka.flatpack.client.impl.ApiBase;
import com.getperka.flatpack.client.impl.RequestBase;
import com.getperka.flatpack.util.FlatPackTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;

public class FlatPackRequestBase<R extends FlatPackRequest<R, X>, X>
extends RequestBase<R, FlatPackEntity<X>>
implements FlatPackRequest<R, X> {
    private final Type returnType;
    private FlatPackEntity<X> toSend;

    protected FlatPackRequestBase(ApiBase api, Type returnType, String method, String path, Object ... args) {
        super(api, method, path, args);
        this.returnType = returnType;
    }

    public FlatPackEntity<X> getEntity() {
        return this.toSend;
    }

    @Override
    public FlatPackEntity<X> peek() {
        return this.getEntity();
    }

    @Override
    public void setEntity(Object entity) {
        this.toSend = FlatPackEntity.create(Object.class, (Object)entity, null);
    }

    @Override
    protected FlatPackEntity<X> execute(HttpURLConnection conn) throws IOException {
        InputStream errorStream;
        int status = conn.getResponseCode();
        InputStreamReader reader = !this.isOk(status) ? ((errorStream = conn.getErrorStream()) == null ? null : new InputStreamReader(errorStream, FlatPackTypes.UTF8)) : new InputStreamReader(conn.getInputStream(), FlatPackTypes.UTF8);
        Exception cause = null;
        FlatPackEntity entity = null;
        if (reader != null) {
            try {
                entity = this.getApi().getFlatPack().getUnpacker().unpack(this.returnType, (Reader)reader, null);
            }
            catch (IOException e) {
                cause = e;
            }
            catch (RuntimeException e) {
                cause = e;
            }
        }
        if (!this.isOk(status)) {
            StatusCodeException sce = new StatusCodeException(status, (Throwable)cause);
            sce.setEntity(entity);
            throw sce;
        }
        return entity;
    }

    @Override
    protected void writeEntity(HttpURLConnection connection) throws IOException {
        if (this.getEntity() == null) {
            return;
        }
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF8");
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), FlatPackTypes.UTF8);
        this.getApi().getFlatPack().getPacker().pack(this.toSend, (Writer)out);
        ((Writer)out).close();
    }
}

