/*
 * Decompiled with CFR 0.152.
 */
package com.getperka.flatpack.client.dto;

import com.getperka.flatpack.BaseHasUuid;
import com.getperka.flatpack.client.dto.ParameterDescription;
import com.getperka.flatpack.ext.Type;
import com.getperka.flatpack.util.FlatPackTypes;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.security.PermitAll;

public class EndpointDescription
extends BaseHasUuid {
    private String docString;
    private Type entity;
    private String method;
    private String path;
    private List<ParameterDescription> pathParameters;
    private List<ParameterDescription> queryParameters;
    private Type returnType;
    private Set<String> roleNames;

    public EndpointDescription(String method, String path) {
        this.method = method;
        this.path = path;
    }

    EndpointDescription() {
    }

    @PermitAll
    public String getDocString() {
        return this.docString;
    }

    @PermitAll
    public Type getEntity() {
        return this.entity;
    }

    @PermitAll
    public String getMethod() {
        return this.method;
    }

    @PermitAll
    public String getPath() {
        return this.path;
    }

    @PermitAll
    public List<ParameterDescription> getPathParameters() {
        return this.pathParameters;
    }

    @PermitAll
    public List<ParameterDescription> getQueryParameters() {
        return this.queryParameters;
    }

    @PermitAll
    public Type getReturnType() {
        return this.returnType;
    }

    @PermitAll
    public Set<String> getRoleNames() {
        return this.roleNames;
    }

    public void setDocString(String docString) {
        this.docString = docString;
    }

    public void setEntity(Type entity) {
        this.entity = entity;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPathParameters(List<ParameterDescription> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public void setQueryParameters(List<ParameterDescription> parameters) {
        this.queryParameters = parameters;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public void setRoleNames(Set<String> roleNames) {
        this.roleNames = roleNames;
    }

    public String toString() {
        return this.method + " " + this.path;
    }

    protected UUID defaultUuid() {
        return UUID.nameUUIDFromBytes((this.method + ":" + this.path).getBytes(FlatPackTypes.UTF8));
    }
}

