/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceServiceConnector;
import com.force.sdk.oauth.ForceUserPrincipal;
import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.oauth.context.ForceSecurityContextHolder;
import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.exception.ForceOAuthSessionExpirationException;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class ForceConnectionStorageFilter
extends GenericFilterBean
implements SessionRenewer {
    private ForceOAuthConnector oauthConnector;
    private Boolean useSession;

    public void setUseSession(Boolean useSession) {
        this.useSession = useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setOauthConnector(ForceOAuthConnector oauthConnector) {
        this.oauthConnector = oauthConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (auth != null && auth.getPrincipal() instanceof ForceUserPrincipal) {
            ForceUserPrincipal user = (ForceUserPrincipal)auth.getPrincipal();
            ForceConnectorConfig cc = new ForceConnectorConfig();
            cc.setSessionId(user.getSessionId());
            SecurityContext sc = (SecurityContext)auth.getDetails();
            cc.setServiceEndpoint(sc.getEndPoint());
            cc.setSessionRenewer((SessionRenewer)this);
            ForceSecurityContextHolder.set((SecurityContext)sc);
            ForceServiceConnector.setThreadLocalConnectorConfig((ForceConnectorConfig)cc);
            try {
                chain.doFilter(request, response);
            }
            catch (ForceOAuthSessionExpirationException e) {
                this.logger.debug((Object)"User's session expired. Redirecting to login screen");
                res.sendRedirect(this.oauthConnector.getLoginRedirectUrl(req));
            }
            finally {
                if (!this.useSession.booleanValue()) {
                    SecurityContextHolder.clearContext();
                }
                ForceServiceConnector.setThreadLocalConnectorConfig(null);
                ForceSecurityContextHolder.release();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig config) throws ConnectionException {
        throw new ForceOAuthSessionExpirationException();
    }
}

