/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.springsecurity.OAuthAuthenticationToken;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private ForceOAuthConnector oauthConnector;
    private String filterProcessesUrlOverride;
    private AuthenticationEntryPoint authenticationEntryPoint;

    protected AuthenticationProcessingFilter() {
        super("/_auth");
    }

    public void setOauthConnector(ForceOAuthConnector oauthConnector) {
        this.oauthConnector = oauthConnector;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrlOverride = filterProcessesUrl;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String uri = request.getRequestURI();
        if (this.filterProcessesUrlOverride != null && this.isAutenticationCandidate(request.getContextPath(), uri, this.filterProcessesUrlOverride)) {
            String referer = request.getHeader("Referer");
            if (StringUtils.hasLength((String)referer)) {
                request.setAttribute("__login_redirect_url_attrbute__", (Object)referer);
            } else {
                request.setAttribute("__login_redirect_url_attrbute__", (Object)"");
            }
            this.authenticationEntryPoint.commence(request, response, null);
            return;
        }
        super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.oauthConnector, (String)"oauthConnector bean must be set");
        if (this.filterProcessesUrlOverride != null) {
            Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint bean must be set when filterProcessesUrl is used");
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        OAuthAuthenticationToken ot = new OAuthAuthenticationToken(this.oauthConnector.getAccessCode(request));
        ot.setDetails(this.oauthConnector.getRedirectUri(request));
        return this.getAuthenticationManager().authenticate((Authentication)ot);
    }

    private boolean isAutenticationCandidate(String contextPath, String uri, String candidate) {
        if ("".equals(contextPath)) {
            return uri.endsWith(candidate);
        }
        return uri.endsWith(contextPath + candidate);
    }
}

