/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.connector.logger;

import java.io.IOException;
import java.io.OutputStream;

public class ForceLoggerStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_LENGTH = 4096;
    private static final int MAX_BUFFER_LENGTH = 65536;
    private StreamLogger logger;
    private byte[] buf;
    private int count;
    private boolean isClosed;

    public ForceLoggerStream(StreamLogger logger) {
        this.logger = logger;
        this.reset();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.isClosed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Logger stream has been closed");
        }
        if (this.buf.length == this.count) {
            if (this.buf.length == 65536) {
                this.flush();
            } else {
                int len = this.buf.length * 2 > 65536 ? 65536 : this.buf.length * 2;
                byte[] tbuf = new byte[len];
                System.arraycopy(this.buf, 0, tbuf, 0, this.count);
                this.buf = tbuf;
            }
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.count == 0 || this.count == 1 && ((char)this.buf[0] == '\n' || (char)this.buf[0] == '\r')) {
            this.reset();
            return;
        }
        this.logger.log(new String(this.buf, 0, this.count));
        this.reset();
    }

    private void reset() {
        this.count = 0;
        this.buf = new byte[4096];
    }

    public static interface StreamLogger {
        public void log(String var1);
    }
}

