/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.connector;

import com.force.sdk.connector.ForceConnector;
import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceConnectorUtils;
import com.force.sdk.connector.threadlocal.ForceThreadLocalStore;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BulkConnection;
import com.sforce.soap.metadata.DescribeMetadataResult;
import com.sforce.soap.metadata.MetadataConnection;
import com.sforce.soap.partner.CallOptions_element;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.SessionHeader_element;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class ForceServiceConnector
implements ForceConnector,
SessionRenewer {
    public static final QName SESSION_HEADER_QNAME = new QName("urn:partner.soap.sforce.com", "SessionHeader");
    private static final Pattern METADATA_URI_PATTERN = Pattern.compile("(.*/Soap)/./(.*)");
    private static final Pattern RESTAPI_URI_PATTERN = Pattern.compile("(.*)/Soap/./(.*)/(.*)$");
    static final double DESCRIBE_METADATA_VERSION = 16.0;
    private static final Proxy DEFAULT_PROXY;
    public static final String API_USER_AGENT;
    private static final Map<String, ForceConnectorConfig> CACHED_CONFIGS;
    private static final Map<String, String> CONN_NAME_TO_CACHED_CONFIGS;
    private boolean skipCache = false;
    private ForceConnectorConfig config;
    private String connectionName;
    private ForceConnectorConfig externalConfig;
    private String clientId;
    private String externalClientId;
    private int timeout;
    private PartnerConnection connection;
    private MetadataConnection metadataConnection;
    private BulkConnection bulkConnection;

    public static ForceConnectorConfig getThreadLocalConnectorConfig() {
        return ForceThreadLocalStore.getConnectorConfig();
    }

    public static void setThreadLocalConnectorConfig(ForceConnectorConfig config) {
        ForceThreadLocalStore.setConnectorConfig(config);
    }

    public ForceServiceConnector() {
    }

    public ForceServiceConnector(String connectionName) {
        this.connectionName = connectionName;
    }

    public ForceServiceConnector(ForceConnectorConfig config) throws ConnectionException {
        if (config == null) {
            throw new IllegalArgumentException("Cannot construct ForceServiceConnector with null ConnectorConfig.");
        }
        this.validateConnectorConfig(config);
        this.externalConfig = config;
    }

    public PartnerConnection getConnection() throws ConnectionException {
        if (this.connection == null) {
            this.initConnection();
        }
        return this.connection;
    }

    private void initConnection() throws ConnectionException {
        if (this.config == null) {
            this.config = this.getConfig();
            this.initConfig();
        }
        this.config.setRequestHeader("User-Agent", API_USER_AGENT);
        this.connection = Connector.newConnection((ConnectorConfig)this.config);
        CallOptions_element co = new CallOptions_element();
        if (this.clientId != null) {
            co.setClient(this.clientId);
        } else if (this.externalClientId != null) {
            co.setClient(this.externalClientId);
        } else {
            co.setClient(API_USER_AGENT);
        }
        this.connection.__setCallOptions(co);
    }

    private ForceConnectorConfig getConfig() throws ConnectionException {
        if (this.externalConfig != null) {
            this.externalClientId = this.externalConfig.getClientId();
            return this.checkConfigCache((ForceConnectorConfig)this.externalConfig.clone());
        }
        if (this.connectionName != null) {
            ForceConnectorConfig loadedConfig;
            ForceConnectorConfig cachedConfig = ForceServiceConnector.getCachedConfig(this.getCacheIdForConnectionName(this.connectionName));
            if (cachedConfig != null) {
                return cachedConfig;
            }
            try {
                loadedConfig = ForceConnectorConfig.loadFromName(this.connectionName);
            }
            catch (IOException e) {
                throw new ConnectionException("Unable to load ForceConnectorConfig for name " + this.connectionName, (Throwable)e);
            }
            if (loadedConfig != null) {
                this.externalClientId = loadedConfig.getClientId();
                return this.checkConfigCache(loadedConfig, this.connectionName);
            }
        }
        if ((this.config = ForceThreadLocalStore.getConnectorConfig()) != null) {
            return this.config;
        }
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("No state was found to construct a connection.").append(" Please provide a ForceConnectorConfig.");
        if (this.connectionName != null) {
            errorMsg.append(" Or create a classpath properties file, environment variable or java property for the name '").append(this.connectionName).append("'");
        }
        throw new ConnectionException(errorMsg.toString());
    }

    private String getCacheIdForConnectionName(String cachedConnectionName) {
        return CONN_NAME_TO_CACHED_CONFIGS.get(cachedConnectionName);
    }

    private void setCacheIdForConnectionName(String cacheConnectionName, String cacheId) {
        if (cacheConnectionName != null && cacheId != null) {
            ForceConnectorUtils.LOGGER.trace("ForceServiceConnector Cache: Mapping connectionName: " + cacheConnectionName + " to cacheId: " + cacheId);
            CONN_NAME_TO_CACHED_CONFIGS.put(cacheConnectionName, cacheId);
        }
    }

    private ForceConnectorConfig checkConfigCache(ForceConnectorConfig configToCheck) throws ConnectionException {
        return this.checkConfigCache(configToCheck, null);
    }

    private ForceConnectorConfig checkConfigCache(ForceConnectorConfig configToCheck, String cachedConnectionName) throws ConnectionException {
        this.validateConnectorConfig(configToCheck);
        String cacheId = configToCheck.getCacheId();
        if (cacheId != null && !this.skipCache) {
            ForceConnectorUtils.LOGGER.trace("ForceServiceConnector Cache: Checking for id: " + cacheId);
            ForceConnectorConfig cachedConfig = ForceServiceConnector.getCachedConfig(cacheId);
            this.setCacheIdForConnectionName(cachedConnectionName, cacheId);
            if (cachedConfig != null) {
                ForceConnectorUtils.LOGGER.trace("ForceServiceConnector Cache: HIT for id: " + cacheId);
                return cachedConfig;
            }
            ForceConnectorUtils.LOGGER.trace("ForceServiceConnector Cache: MISS for id: " + cacheId);
            CACHED_CONFIGS.put(cacheId, configToCheck);
        }
        return configToCheck;
    }

    private void validateConnectorConfig(ForceConnectorConfig configToValidate) throws ConnectionException {
        if (configToValidate.getSessionId() == null && configToValidate.getAuthEndpoint() == null) {
            throw new ConnectionException("ForceConnectorConfig must have an AuthEndpoint");
        }
        if (configToValidate.getSessionId() == null && configToValidate.getUsername() == null) {
            throw new ConnectionException("ForceConnectorConfig must have a Username");
        }
    }

    private void initConfig() {
        if (this.config.getSessionRenewer() == null) {
            this.config.setSessionRenewer(this);
        }
        if (DEFAULT_PROXY != null && (this.config.getProxy() != Proxy.NO_PROXY || this.config.getProxy().type() == Proxy.Type.DIRECT)) {
            this.config.setProxy(DEFAULT_PROXY);
        }
        if (this.timeout > 0) {
            this.config.setReadTimeout(this.timeout);
        }
    }

    public MetadataConnection getMetadataConnection() throws ConnectionException {
        if (this.metadataConnection == null) {
            this.initMetadataConnection();
        }
        return this.metadataConnection;
    }

    private void initMetadataConnection() throws ConnectionException {
        if (this.connection == null) {
            this.initConnection();
        }
        ConnectorConfig configNew = new ConnectorConfig();
        configNew.setSessionId(this.config.getSessionId());
        configNew.setServiceEndpoint(METADATA_URI_PATTERN.matcher(this.config.getServiceEndpoint()).replaceFirst("$1/m/$2"));
        this.metadataConnection = new MetadataConnection(configNew);
        if (this.clientId != null) {
            this.metadataConnection.setCallOptions(this.clientId);
        } else if (this.externalClientId != null) {
            this.metadataConnection.setCallOptions(this.externalClientId);
        } else {
            this.metadataConnection.setCallOptions(API_USER_AGENT);
        }
        this.metadataConnection.getConfig().setRequestHeader("User-Agent", API_USER_AGENT);
    }

    public BulkConnection getBulkConnection() throws ConnectionException, AsyncApiException {
        if (this.bulkConnection == null) {
            this.initBulkConnection();
        }
        return this.bulkConnection;
    }

    private void initBulkConnection() throws ConnectionException, AsyncApiException {
        if (this.connection == null) {
            this.initConnection();
        }
        ConnectorConfig configNew = new ConnectorConfig();
        configNew.setSessionId(this.config.getSessionId());
        configNew.setServiceEndpoint(this.config.getServiceEndpoint());
        configNew.setRestEndpoint(RESTAPI_URI_PATTERN.matcher(this.config.getServiceEndpoint()).replaceFirst("$1/async/$2/"));
        this.bulkConnection = new BulkConnection(configNew);
    }

    public String getNamespace() throws ConnectionException {
        if (this.metadataConnection == null) {
            this.initMetadataConnection();
        }
        if (!this.config.isNamespaceInitialized()) {
            DescribeMetadataResult result = this.metadataConnection.describeMetadata(16.0);
            String organizationNamespace = result.getOrganizationNamespace();
            this.config.setNamespace(organizationNamespace != null && organizationNamespace.length() > 0 ? organizationNamespace : null);
        }
        return this.config.getNamespace();
    }

    public void close() {
        this.config = null;
        this.connectionName = null;
        this.externalConfig = null;
        this.clientId = null;
        this.externalClientId = null;
        this.timeout = 0;
        this.connection = null;
        this.metadataConnection = null;
        this.bulkConnection = null;
    }

    static void clearCache() {
        CACHED_CONFIGS.clear();
        CONN_NAME_TO_CACHED_CONFIGS.clear();
    }

    static Map<String, ForceConnectorConfig> getCachedConfigs() {
        return CACHED_CONFIGS;
    }

    static ForceConnectorConfig getCachedConfig(String cacheId) {
        if (cacheId == null) {
            return null;
        }
        return CACHED_CONFIGS.get(cacheId);
    }

    public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig connectorConfig) throws ConnectionException {
        if (connectorConfig.getPassword() != null) {
            connectorConfig.setSessionId(null);
            this.close();
            this.setConnectorConfig((ForceConnectorConfig)connectorConfig);
            this.getConnection();
            SessionRenewer.SessionRenewalHeader ret = new SessionRenewer.SessionRenewalHeader();
            ret.name = SESSION_HEADER_QNAME;
            SessionHeader_element se = new SessionHeader_element();
            se.setSessionId(connectorConfig.getSessionId());
            ret.headerElement = se;
            return ret;
        }
        return null;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setConnectorConfig(ForceConnectorConfig connectorConfig) {
        this.externalConfig = connectorConfig;
    }

    public void setSkipCache(boolean skipCache) {
        this.skipCache = skipCache;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    static {
        if (PROXY_HOST != null) {
            InetSocketAddress addr = new InetSocketAddress(PROXY_HOST, PROXY_PORT);
            DEFAULT_PROXY = new Proxy(Proxy.Type.HTTP, addr);
        } else {
            DEFAULT_PROXY = null;
        }
        String sdkVersion = null;
        Properties projectProps = new Properties();
        try {
            projectProps.load(ForceServiceConnector.class.getClassLoader().getResource("sdk.properties").openStream());
            sdkVersion = projectProps.getProperty("force.sdk.version");
        }
        catch (IOException e) {
            ForceConnectorUtils.LOGGER.error("Unable to load project properties. Logs will not include sdk version!");
        }
        if (sdkVersion == null) {
            sdkVersion = "";
        }
        API_USER_AGENT = String.format("sdk-%s", sdkVersion);
        CACHED_CONFIGS = new ConcurrentHashMap<String, ForceConnectorConfig>();
        CONN_NAME_TO_CACHED_CONFIGS = new ConcurrentHashMap<String, String>();
    }
}

