/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.connector;

import com.force.sdk.connector.ForceConnectionProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForceConnectorUtils {
    static File cliforceConnFile = new File(System.getProperty("cliforce.home", System.getProperty("user.home")) + "/.force/cliforce_urls");
    static final Logger LOGGER = LoggerFactory.getLogger((String)"com.force.sdk.connector");
    static final String FORCE_API_ENDPOINT_PATH;
    static final Map<String, Map<ForceConnectionProperty, String>> PROPERTIES_CACHE;

    private ForceConnectorUtils() {
    }

    public static String buildForceApiEndpoint(String endpoint) {
        String[] parsedEndpoint = endpoint.split("://");
        String endpointNoProtocol = parsedEndpoint[parsedEndpoint.length - 1];
        StringBuffer apiEndpoint = new StringBuffer(endpointNoProtocol);
        if (!endpointNoProtocol.contains("/services/Soap/u")) {
            if (endpointNoProtocol.charAt(endpointNoProtocol.length() - 1) == '/') {
                apiEndpoint.deleteCharAt(endpointNoProtocol.length() - 1);
            }
            apiEndpoint.append(FORCE_API_ENDPOINT_PATH);
        }
        if (endpointNoProtocol.startsWith("localhost") || endpointNoProtocol.contains("internal")) {
            if (parsedEndpoint.length == 2) {
                apiEndpoint.insert(0, "://");
                apiEndpoint.insert(0, parsedEndpoint[0]);
            } else {
                apiEndpoint.insert(0, "http://");
            }
        } else {
            apiEndpoint.insert(0, "https://");
        }
        return apiEndpoint.toString();
    }

    public static boolean isInjectable(String var) {
        return var != null && var.startsWith("${") && var.endsWith("}");
    }

    public static String extractValue(String var) {
        if (var != null) {
            if (!var.startsWith("${") || !var.endsWith("}")) {
                return null;
            }
            var = var.replace("${", "");
            if ((var = var.substring(0, var.length() - 1)) != null) {
                if (System.getProperty(var) != null) {
                    LOGGER.info("Connection : loading " + var + " from Java System Properties");
                    return System.getProperty(var);
                }
                if (System.getenv(var) != null) {
                    LOGGER.info("Connection : loading " + var + " from Environment Variables");
                    return System.getenv(var);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ForceConnectionProperty, String> loadConnectorPropsFromName(String connectionName) throws IOException {
        if (connectionName == null) {
            return null;
        }
        if (PROPERTIES_CACHE.containsKey(connectionName)) {
            LOGGER.info("Connection : loading " + connectionName + " from cache");
            return PROPERTIES_CACHE.get(connectionName);
        }
        String envVarName = "FORCE_" + connectionName.toUpperCase() + "_URL";
        String connectionUrl = System.getenv(envVarName);
        if (connectionUrl != null) {
            LOGGER.info("Connection : Creating " + connectionName + " from environment variable: " + envVarName);
            return ForceConnectorUtils.cache(connectionName, ForceConnectorUtils.loadConnectorPropsFromUrl(connectionUrl));
        }
        String sysPropName = "force." + connectionName + ".url";
        connectionUrl = System.getProperty(sysPropName);
        if (connectionUrl != null) {
            LOGGER.info("Connection : Creating " + connectionName + " from Java system property: " + sysPropName);
            return ForceConnectorUtils.cache(connectionName, ForceConnectorUtils.loadConnectorPropsFromUrl(connectionUrl));
        }
        URL propsFileUrl = ForceConnectorUtils.class.getResource("/" + connectionName + ".properties");
        if (propsFileUrl != null) {
            LOGGER.info("Connection : Creating " + connectionName + " from classpath properties file: " + propsFileUrl);
            return ForceConnectorUtils.cache(connectionName, ForceConnectorUtils.loadConnectorPropsFromFile(propsFileUrl));
        }
        if (cliforceConnFile.canRead()) {
            FileInputStream is = null;
            Properties cliforceConnUrls = new Properties();
            try {
                is = new FileInputStream(cliforceConnFile);
                cliforceConnUrls.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            if (cliforceConnUrls.containsKey(connectionName)) {
                LOGGER.info("Connection : Creating " + connectionName + " from cliforce connections file: " + cliforceConnFile);
                return ForceConnectorUtils.cache(connectionName, ForceConnectorUtils.loadConnectorPropsFromUrl(cliforceConnUrls.getProperty(connectionName)));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<ForceConnectionProperty, String> loadConnectorPropsFromFile(URL fileUrl) throws IOException {
        if (fileUrl == null) {
            throw new IllegalArgumentException("Connector property file cannot be null.");
        }
        Properties connectorProps = new Properties();
        InputStream is = null;
        try {
            is = fileUrl.openStream();
            connectorProps.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (connectorProps.containsKey("url")) {
            return ForceConnectorUtils.loadConnectorPropsFromUrl(connectorProps.getProperty("url"));
        }
        HashMap<ForceConnectionProperty, String> connectorPropMap = new HashMap<ForceConnectionProperty, String>(connectorProps.size());
        for (String propName : connectorProps.stringPropertyNames()) {
            ForceConnectionProperty connProp = ForceConnectionProperty.fromPropertyName(propName);
            if (connProp == null) continue;
            connectorPropMap.put(connProp, connectorProps.getProperty(propName));
        }
        return connectorPropMap;
    }

    public static Map<ForceConnectionProperty, String> loadConnectorPropsFromUrl(String connectionUrl) {
        String[] parsedQueryString;
        URI connectionUri;
        if (connectionUrl == null) {
            throw new IllegalArgumentException("Connection url cannot be null.");
        }
        try {
            connectionUri = new URI(connectionUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse connection url (" + connectionUrl + ")", e);
        }
        if (!"force".equals(connectionUri.getScheme())) {
            throw new IllegalArgumentException("Illegal prefix for connection url (" + connectionUrl + "). " + "It must start with force://");
        }
        HashMap<ForceConnectionProperty, String> connectorPropMap = new HashMap<ForceConnectionProperty, String>(3);
        String endpoint = connectionUri.getHost();
        if (endpoint != null) {
            StringBuffer sb = new StringBuffer(endpoint);
            if (connectionUri.getPort() > -1) {
                sb.append(":").append(connectionUri.getPort());
            }
            if (connectionUri.getPath() != null) {
                sb.append(connectionUri.getPath());
            }
            endpoint = sb.toString();
        }
        ForceConnectionProperty.ENDPOINT.validateValue(endpoint, "Illegal connection url (" + connectionUrl + ").");
        connectorPropMap.put(ForceConnectionProperty.ENDPOINT, endpoint);
        String queryString = connectionUri.getQuery();
        if (queryString == null) {
            return connectorPropMap;
        }
        for (String queryParam : parsedQueryString = connectionUri.getQuery().split("&")) {
            ForceConnectionProperty connProp;
            String[] parsedUrlProperty = queryParam.split("=", 2);
            if (parsedUrlProperty.length != 2 || (connProp = ForceConnectionProperty.fromPropertyName(parsedUrlProperty[0])) == null) continue;
            connectorPropMap.put(connProp, parsedUrlProperty[1]);
        }
        return connectorPropMap;
    }

    static int parsePortNumber(String port, int defaultPort) {
        int proxyPort = defaultPort;
        if (port != null) {
            try {
                proxyPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ne) {
                LOGGER.warn("Unable to parse port '" + port + "'. Using default port number " + defaultPort, (Throwable)ne);
            }
        }
        return proxyPort;
    }

    private static Map<ForceConnectionProperty, String> cache(String connectionName, Map<ForceConnectionProperty, String> props) {
        PROPERTIES_CACHE.put(connectionName, props);
        return props;
    }

    public static void clearCache() {
        PROPERTIES_CACHE.clear();
    }

    static {
        PROPERTIES_CACHE = new ConcurrentHashMap<String, Map<ForceConnectionProperty, String>>();
        try {
            FORCE_API_ENDPOINT_PATH = new URL("http://javacloud.internal.salesforce.com:8000/services/Soap/u/22.0").getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to load Force.com API Endpoint path", e);
        }
    }
}

