/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.connector;

import com.force.sdk.connector.ForceConnectionProperty;
import com.force.sdk.connector.ForceConnectorUtils;
import com.force.sdk.connector.logger.ForceLoggerStream;
import com.sforce.ws.ConnectorConfig;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;

public class ForceConnectorConfig
extends ConnectorConfig
implements Cloneable {
    private static final int MIN_CONN_URL_PROPS = 3;
    private boolean namespaceInitialized;
    private String namespace;
    private String cacheId;
    private String clientId;
    private PrintStream loggerStream;

    static ForceConnectorConfig loadFromName(String connectionName) throws IOException {
        Map<ForceConnectionProperty, String> propMap = ForceConnectorUtils.loadConnectorPropsFromName(connectionName);
        if (propMap == null) {
            return null;
        }
        ForceConnectorConfig config = new ForceConnectorConfig();
        config.setPropsFromMap(propMap, connectionName);
        return config;
    }

    public ForceConnectorConfig() {
        this.setTraceMessage(true);
    }

    public void setAuthEndpoint(String authEndpoint) {
        super.setAuthEndpoint(ForceConnectorUtils.buildForceApiEndpoint(authEndpoint));
        this.initCacheId();
    }

    private void initCacheId() {
        String username = this.getUsername();
        String endpoint = this.getAuthEndpoint();
        this.cacheId = username != null && endpoint != null ? username + endpoint : null;
    }

    String getCacheId() {
        return this.cacheId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setConnectionUrl(String connectionUrl) {
        Map<ForceConnectionProperty, String> propMap = ForceConnectorUtils.loadConnectorPropsFromUrl(connectionUrl);
        if (propMap == null || propMap.size() < 3) {
            throw new IllegalArgumentException("The connection url (" + connectionUrl + ") must contain at least three parts. " + "It should be in the form force://<endPoint>?user=<user>&password=<password>");
        }
        this.setPropsFromMap(propMap, connectionUrl);
    }

    boolean isNamespaceInitialized() {
        return this.namespaceInitialized;
    }

    void setNamespace(String namespace) {
        this.namespace = namespace;
        this.namespaceInitialized = true;
    }

    String getNamespace() {
        return this.namespace;
    }

    private void setPropsFromMap(Map<ForceConnectionProperty, String> propMap, String propSource) {
        String timeoutValue;
        String errorMessage = "Could not load valid ForceConnectorConfig properties from " + propSource + ".";
        String endpointValue = propMap.get((Object)ForceConnectionProperty.ENDPOINT);
        ForceConnectionProperty.ENDPOINT.validateValue(endpointValue, errorMessage);
        this.setAuthEndpoint(endpointValue);
        String userValue = propMap.get((Object)ForceConnectionProperty.USER);
        ForceConnectionProperty.USER.validateValue(userValue, errorMessage);
        this.setUsername(userValue);
        String passwordValue = propMap.get((Object)ForceConnectionProperty.PASSWORD);
        ForceConnectionProperty.PASSWORD.validateValue(passwordValue, errorMessage);
        this.setPassword(passwordValue);
        String clientIdValue = propMap.get((Object)ForceConnectionProperty.CLIENTID);
        if (clientIdValue != null) {
            ForceConnectionProperty.CLIENTID.validateValue(clientIdValue, errorMessage);
            this.setClientId(clientIdValue);
        }
        if ((timeoutValue = propMap.get((Object)ForceConnectionProperty.TIMEOUT)) != null) {
            ForceConnectionProperty.TIMEOUT.validateValue(timeoutValue, errorMessage);
            int timeout = Integer.valueOf(timeoutValue);
            if (timeout > 0) {
                this.setReadTimeout(timeout);
            }
        }
    }

    public void setTraceMessage(boolean traceMessage) {
        this.loggerStream = traceMessage && ForceConnectorUtils.LOGGER.isTraceEnabled() ? new PrintStream(new ForceLoggerStream(new ForceLoggerStream.StreamLogger(){

            @Override
            public void log(String msg) {
                ForceConnectorUtils.LOGGER.trace(msg);
            }
        })) : null;
        super.setTraceMessage(this.loggerStream != null);
    }

    public void setUsername(String username) {
        super.setUsername(username);
        this.initCacheId();
    }

    public PrintStream getTraceStream() {
        if (this.loggerStream != null) {
            return this.loggerStream;
        }
        return super.getTraceStream();
    }

    public int hashCode() {
        return this.cacheId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForceConnectorConfig)) {
            return false;
        }
        return this.cacheId.equals(((ForceConnectorConfig)obj).cacheId);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

