/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.connector;

import java.util.regex.Pattern;

public enum ForceConnectionProperty {
    ENDPOINT("endpoint", Pattern.compile("^(http://|https://)?([A-Za-z0-9_.\\-:]+)(/|/services/Soap/u/(\\d+|\\d+.\\d+))?$")),
    USER("user", null),
    PASSWORD("password", null),
    OAUTH_KEY("oauth_key", null),
    OAUTH_SECRET("oauth_secret", Pattern.compile("(\\d+)")),
    CLIENTID("clientid", null),
    TIMEOUT("timeout", Pattern.compile("(\\d+)"));

    private String propertyName;
    private Pattern validationRegex;

    private ForceConnectionProperty(String propertyName, Pattern validationRegex) {
        this.propertyName = propertyName;
        this.validationRegex = validationRegex;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Pattern getValidationRegex() {
        return this.validationRegex;
    }

    public void validateValue(String propertyValue) {
        this.validateValue(propertyValue, "");
    }

    public void validateValue(String propertyValue, String customErrorMessage) {
        if ("endpoint".equals(this.propertyName) && propertyValue != null && propertyValue.contains("localhost")) {
            return;
        }
        if (propertyValue == null || propertyValue.length() == 0) {
            StringBuffer errorMessage = new StringBuffer(customErrorMessage);
            errorMessage.append(" The ForceConnectionProperty (" + this.propertyName + ") must have a value");
            throw new IllegalArgumentException(errorMessage.toString());
        }
        if (this.validationRegex == null) {
            return;
        }
        if (!this.validationRegex.matcher(propertyValue).matches()) {
            StringBuffer errorMessage = new StringBuffer(customErrorMessage);
            errorMessage.append(" Illegal value (" + propertyValue + ") for ForceConnectionProperty (" + this.propertyName + ")");
            throw new IllegalArgumentException(errorMessage.toString());
        }
    }

    public static ForceConnectionProperty fromPropertyName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        for (ForceConnectionProperty connProp : ForceConnectionProperty.values()) {
            if (!connProp.getPropertyName().equals(propertyName.toLowerCase())) continue;
            return connProp;
        }
        return null;
    }
}

