/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.tools;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection {
    private static Logger internalLogger = LoggerFactory.getLogger((String)"internal");
    private HttpParams params;
    private HttpHost host;
    private DefaultHttpClient client;

    public HttpConnection(String hostName, int port) {
        this.host = new HttpHost(hostName, port);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.setMaxTotal(10);
        this.params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)this.params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)this.params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)this.params, (String)"HttpComponents/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)this.params, (boolean)true);
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, this.params);
    }

    public HttpResponse get(String url) throws IOException {
        return this.request((HttpRequest)new HttpGet(url));
    }

    public HttpResponse post(String url, String content) throws IOException {
        String printable = content.length() > 100 ? content.substring(0, 100) + " [snip]..." : content;
        internalLogger.debug("Posting " + printable + " to " + url);
        return this.post(url, (HttpEntity)new StringEntity(content, "UTF-8"));
    }

    public HttpResponse post(String url, InputStream content) throws IOException {
        return this.post(url, (HttpEntity)new InputStreamEntity(content, -1L));
    }

    private HttpResponse post(String url, HttpEntity entity) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setEntity(entity);
        return this.request((HttpRequest)request);
    }

    public HttpResponse delete(String url) throws IOException {
        return this.request((HttpRequest)new HttpDelete(url));
    }

    private HttpResponse request(HttpRequest request) throws IOException {
        return this.client.execute(this.host, request);
    }
}

