/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.tools;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hasher {
    private MessageDigest md;
    private static final char[] DIGIT_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public Hasher(String algorithm) throws NoSuchAlgorithmException {
        this.md = MessageDigest.getInstance(algorithm);
    }

    public byte[] hashBytes(String content) {
        return this.md.digest(content.getBytes(Charset.forName("UTF-8")));
    }

    public MessageDigest getMessageDigest() {
        return this.md;
    }

    public char[] hashChars(String content) {
        byte[] data = this.hashBytes(content);
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGIT_CHARS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGIT_CHARS[0xF & data[i]];
        }
        return out;
    }

    public String hashString(String content) {
        return new String(this.hashChars(content));
    }
}

