/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.tools;

import java.lang.reflect.Method;
import java.math.BigDecimal;

public final class Comparator {
    private Comparator() {
    }

    public static boolean equals(Number o, Number p) {
        if (o == null && p == null) {
            return true;
        }
        if (o == null ^ p == null) {
            return false;
        }
        if (o.equals(p)) {
            return true;
        }
        return Comparator.comparisonEquals(o, p);
    }

    private static boolean comparisonEquals(Number o, Number p) {
        if (Comparator.isDecimal(o)) {
            if (Comparator.isDecimal(p)) {
                return o.doubleValue() == p.doubleValue();
            }
            return o.doubleValue() == (double)p.longValue();
        }
        if (Comparator.isDecimal(p)) {
            return (double)o.longValue() == p.doubleValue();
        }
        return o.longValue() == p.longValue();
    }

    public static boolean isDecimal(Number o) {
        return o instanceof Double || o instanceof Float || o instanceof BigDecimal;
    }

    public static boolean isInteger(Number o) {
        return !Comparator.isDecimal(o);
    }

    public static boolean isCharacter(Object o) {
        try {
            Comparator.toCharacter(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public static Character toCharacter(Object o) {
        if (o instanceof Character) {
            return (Character)o;
        }
        if (o instanceof CharSequence && ((CharSequence)o).length() == 1) {
            return Character.valueOf(((CharSequence)o).charAt(0));
        }
        if (o instanceof char[] && ((char[])o).length == 1) {
            return Character.valueOf(((char[])o)[0]);
        }
        if (o instanceof Character[] && ((Character[])o).length == 1) {
            return ((Character[])o)[0];
        }
        throw new ClassCastException("Cannot cast " + o.getClass().getName() + " to " + Character.class);
    }

    public static boolean equals(Object o, Object p) {
        if (o == null && p == null) {
            return true;
        }
        if (o == null || p == null) {
            return false;
        }
        if (o.equals(p)) {
            return true;
        }
        Object o2 = o;
        Object p2 = p;
        if (Comparator.isCharacter(o)) {
            o2 = (int)Comparator.toCharacter(o).charValue();
        }
        if (Comparator.isCharacter(p)) {
            p2 = (int)Comparator.toCharacter(p).charValue();
        }
        try {
            return Comparator.equals((Number)o2, (Number)p2);
        }
        catch (Exception e) {
            try {
                return ((Comparable)o2).compareTo(p2) == 0;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    public static boolean getterEqual(Class c, Object o, Object o2) {
        Method[] methods;
        for (Method m : methods = c.getMethods()) {
            if (!Comparator.isGetter(m)) continue;
            try {
                Object oRes = m.invoke(o, new Object[0]);
                Object o2Res = m.invoke(o2, new Object[0]);
                if (oRes.equals(o2Res)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isGetter(Method m) {
        String name = m.getName();
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return true;
        }
        return m.getReturnType().equals(Boolean.class) && name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2));
    }
}

