/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.stage;

import com.findwise.hydra.JsonException;
import com.findwise.hydra.Logging;
import com.findwise.hydra.SerializationUtils;
import com.findwise.hydra.stage.AbstractStage;
import com.findwise.hydra.stage.RequiredArgumentMissingException;
import com.findwise.tools.HttpConnection;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupStarter {
    public static final Logger logger = LoggerFactory.getLogger(GroupStarter.class);
    public static final String GET_STAGES_URL = "getStages";
    public static final String GROUP_PARAM = "group";

    public static void main(String[] args) throws UnknownHostException {
        List<String> stages;
        if (args.length < 1) {
            logger.error("No group name found", (Throwable)new RequiredArgumentMissingException("No group name specified"));
            System.exit(1);
        }
        String groupName = args[0];
        String host = args.length > 1 ? args[1] : "localhost";
        String port = args.length > 2 ? args[2] : "12001";
        String logging = args.length > 3 ? args[3] : "false";
        String logPort = args.length > 4 ? args[4] : "12002";
        try {
            Logging.setup(host, Integer.parseInt(logPort));
        }
        catch (UnknownHostException e) {
            logger.error("Unable to connect to remote logging host on " + host + ":" + logPort, (Throwable)e);
            return;
        }
        try {
            stages = GroupStarter.getStages(host, Integer.parseInt(port), groupName);
        }
        catch (IOException e) {
            Logging.addConsoleAppender();
            logger.error("Unable to get stages for the group '" + groupName + "'", (Throwable)e);
            return;
        }
        try {
            for (String stage : stages) {
                logger.debug("Attempting to start stage: " + stage);
                AbstractStage.main(new String[]{stage, host, port, logging, logPort});
            }
        }
        catch (Exception e) {
            Logging.addConsoleAppender();
            logger.error("An exception was thrown when starting the stages in the group", (Throwable)e);
        }
    }

    public static List<String> getStages(String host, int port, String group) throws IOException {
        HttpConnection connection = new HttpConnection(host, port);
        HttpResponse response = connection.get("/getStages?group=" + group);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.error("Unable to get list stages in the group");
            return new ArrayList<String>();
        }
        try {
            return (List)SerializationUtils.toObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (JsonException e) {
            logger.error("Unable to deserialize list of stages", (Throwable)e);
            return new ArrayList<String>();
        }
    }
}

