/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.stage;

import com.findwise.hydra.JsonDeserializer;
import com.findwise.hydra.JsonException;
import com.findwise.hydra.Logging;
import com.findwise.hydra.SerializationUtils;
import com.findwise.hydra.local.LocalQuery;
import com.findwise.hydra.local.RemotePipeline;
import com.findwise.hydra.stage.Parameter;
import com.findwise.hydra.stage.RequiredArgumentMissingException;
import com.findwise.hydra.stage.Stage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStage
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(AbstractStage.class);
    public static final String ARG_NAME_STAGE_CLASS = "stageClass";
    public static final String PROPERTY_NAME_COMMANDLINE_ARGS = "cmdline_args";
    @Parameter(description="The Query that this stage will recieve documents matching")
    private LocalQuery query = new LocalQuery();
    @Parameter(description="Number of instances (threads) to start of this stage within a single JVM. Defaults to 1.")
    private int numberOfThreads = 1;
    public static final int CMDLINE_STAGE_NAME_PARAM = 0;
    public static final int CMDLINE_PIPELINE_HOST_PARAM = 1;
    public static final int CMDLINE_PIPELINE_PORT_PARAM = 2;
    public static final int CMDLINE_PERFORMANCE_LOG_PARAM = 3;
    public static final int DEFAULT_HOLD_INTERVAL = 2000;
    private RemotePipeline remotePipeline = null;
    private Thread shutDownHook;
    private String stageName;
    private boolean continueRunning;

    public LocalQuery getQuery() {
        return this.query;
    }

    public void init() throws RequiredArgumentMissingException {
    }

    public Thread getShutDownHook() {
        return this.shutDownHook;
    }

    public void setShutDownHook(Thread shutDownHook) {
        this.shutDownHook = shutDownHook;
    }

    public RemotePipeline getRemotePipeline() {
        return this.remotePipeline;
    }

    public void setRemotePipeline(RemotePipeline rp) {
        this.remotePipeline = rp;
    }

    public synchronized void stopStage() {
        this.continueRunning = false;
    }

    protected synchronized boolean isContinueRunning() {
        return this.continueRunning;
    }

    protected synchronized void setContinueRunning(boolean val) {
        this.continueRunning = val;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setParameters(Map<String, Object> map) throws IllegalArgumentException, IllegalAccessException {
        if (this.getClass().isAnnotationPresent(Stage.class)) {
            for (Field field : this.getParameterFields()) {
                if (!map.containsKey(field.getName())) continue;
                boolean prevAccessible = field.isAccessible();
                if (!prevAccessible) {
                    field.setAccessible(true);
                }
                if (this.hasInterface(field.getType(), JsonDeserializer.class)) {
                    try {
                        JsonDeserializer jd = (JsonDeserializer)field.getType().newInstance();
                        jd.fromJson(SerializationUtils.toJson(map.get(field.getName())));
                        field.set(this, jd);
                    }
                    catch (InstantiationException e) {
                        field.set(this, map.get(field.getName()));
                    }
                    catch (JsonException e) {
                        field.set(this, map.get(field.getName()));
                    }
                } else if (field.getType().isEnum() && !map.get(field.getName()).getClass().isEnum()) {
                    Object value = map.get(field.getName());
                    try {
                        if (value instanceof Integer) {
                            field.set(this, field.getType().getEnumConstants()[(Integer)value]);
                        } else if (value instanceof String) {
                            field.set(this, field.getType().getDeclaredMethod("valueOf", String.class).invoke(null, value));
                        }
                    }
                    catch (Exception e) {
                        field.set(this, value);
                    }
                } else {
                    field.set(this, map.get(field.getName()));
                }
                field.setAccessible(prevAccessible);
            }
        } else {
            throw new NoSuchElementException("No Stage-annotation found on the specified class " + this.getClass().getCanonicalName());
        }
    }

    private boolean hasInterface(Class<?> c, Class<?> inf) {
        for (Class<?> x : c.getInterfaces()) {
            if (!x.equals(inf)) continue;
            return true;
        }
        return false;
    }

    public List<Field> getParameterFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        this.addParameterFields(list, this.getClass());
        return list;
    }

    private void addParameterFields(List<Field> list, Class<?> startClass) {
        for (Field field : startClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Parameter.class)) continue;
            list.add(field);
        }
        Class<?> superClass = startClass.getSuperclass();
        if (!superClass.equals(Object.class)) {
            this.addParameterFields(list, superClass);
        }
    }

    public void setUp(RemotePipeline rp, Map<String, Object> properties) throws IllegalArgumentException, IllegalAccessException, IOException {
        this.setRemotePipeline(rp);
        this.setParameters(properties);
        this.createAndApplyShutDownHook();
    }

    public static List<AbstractStage> getInstances(String[] args) throws UnknownHostException {
        ArrayList<AbstractStage> list = new ArrayList<AbstractStage>();
        int numberOfThreads = 1;
        do {
            AbstractStage stage;
            if ((stage = AbstractStage.getInstance(args)) == null) {
                return null;
            }
            numberOfThreads = stage.numberOfThreads;
            list.add(stage);
        } while (list.size() < numberOfThreads);
        return list;
    }

    public static RemotePipeline getRemotePipeline(String[] args) {
        String stageName = 0 < args.length ? args[0] : null;
        String hostName = 1 < args.length ? args[1] : "127.0.0.1";
        String port = 2 < args.length ? args[2] : "12001";
        boolean logging = 3 < args.length ? Boolean.parseBoolean(args[3]) : false;
        RemotePipeline rp = new RemotePipeline(hostName, Integer.parseInt(port), stageName);
        rp.setPerformanceLogging(logging);
        return rp;
    }

    public static AbstractStage getInstance(String[] args) throws UnknownHostException {
        logger.debug("Getting AbstractStage with args: " + Arrays.toString(args));
        if (args.length < 1) {
            logger.error("No stage name found", (Throwable)new RequiredArgumentMissingException("No stage name was specified"));
            System.exit(1);
        }
        try {
            RemotePipeline rp = AbstractStage.getRemotePipeline(args);
            Map<String, Object> properties = rp.getProperties();
            if (!properties.containsKey(ARG_NAME_STAGE_CLASS)) {
                throw new RequiredArgumentMissingException("No class specified in the 'stageClass' property.");
            }
            String stageClass = (String)properties.get(ARG_NAME_STAGE_CLASS);
            Class<?> actualClass = Class.forName(stageClass);
            AbstractStage stage = (AbstractStage)actualClass.newInstance();
            stage.setName(rp.getStageName());
            stage.setStageName(rp.getStageName());
            stage.setUp(rp, properties);
            stage.init();
            return stage;
        }
        catch (RequiredArgumentMissingException e) {
            logger.error("Failed to read arguments", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not find the Stage class in classpath", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Could not instantiate the Stage class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Could not access constructor of Stage class", (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error("Communication failiure when reading properties", (Throwable)e);
        }
        return null;
    }

    public static void main(String[] args) throws UnknownHostException {
        List<AbstractStage> stages;
        if (args.length > 1) {
            Logging.setup(args[1], Integer.parseInt(args[4]));
        }
        if ((stages = AbstractStage.getInstances(args)) == null || stages.size() < 1) {
            logger.error("Unable to instantiate any stages for input: " + Arrays.toString(args));
        } else {
            for (AbstractStage stage : stages) {
                stage.start();
            }
            logger.info("Started " + stages.size() + " instances of stage: " + stages.get(0).getName() + ". Running with the query: " + stages.get(0).getQuery());
        }
    }

    public void onDestroy() {
    }

    public Thread createAndApplyShutDownHook() {
        this.shutDownHook = new OnDestroyThread();
        this.shutDownHook.setName(this.stageName);
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        return this.shutDownHook;
    }

    private class OnDestroyThread
    extends Thread {
        private OnDestroyThread() {
        }

        @Override
        public void run() {
            logger.info("Shutting down stage: " + this.getName());
            if (AbstractStage.this.isAlive()) {
                AbstractStage.this.setContinueRunning(false);
                try {
                    AbstractStage.this.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AbstractStage.this.onDestroy();
        }
    }
}

