/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.stage;

import com.findwise.hydra.local.LocalDocument;
import com.findwise.hydra.local.RemotePipeline;
import com.findwise.hydra.stage.AbstractProcessStage;
import com.findwise.hydra.stage.ProcessException;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOutputStage
extends AbstractProcessStage {
    Logger logger = LoggerFactory.getLogger(AbstractOutputStage.class);

    @Override
    public void setUp(RemotePipeline rp, Map<String, Object> properties) throws IllegalArgumentException, IllegalAccessException, IOException {
        super.setUp(rp, properties);
    }

    @Override
    public void process(LocalDocument document) throws ProcessException {
        this.logger.debug("Processing document: " + document.getID());
        this.output(document);
    }

    public abstract void output(LocalDocument var1);

    protected boolean accept(LocalDocument document) throws IOException {
        return this.getRemotePipeline().markProcessed(document);
    }

    protected boolean pending(LocalDocument document) throws IOException {
        return this.getRemotePipeline().markPending(document);
    }

    protected boolean fail(LocalDocument document) throws IOException {
        return this.getRemotePipeline().markFailed(document);
    }

    protected boolean fail(LocalDocument document, Throwable throwable) throws IOException {
        return this.getRemotePipeline().markFailed(document, throwable);
    }

    @Override
    protected boolean persist() {
        return true;
    }
}

