/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.stage;

import com.findwise.hydra.local.LocalDocument;
import com.findwise.hydra.stage.AbstractProcessStage;
import com.findwise.hydra.stage.Parameter;
import com.findwise.hydra.stage.ProcessException;
import com.findwise.hydra.stage.RequiredArgumentMissingException;
import java.util.Map;

public abstract class AbstractMappingProcessStage
extends AbstractProcessStage {
    @Parameter(description="Map from String to String, e.g. {inField:outField}. A map such as {key:value} will cause this stage to perform it's action on the value of the field 'key' and store it into the field 'value'")
    private Map<String, String> map;

    @Override
    public final void process(LocalDocument doc) throws ProcessException {
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            if (!doc.hasContentField(e.getKey())) continue;
            this.processField(doc, e.getKey(), e.getValue());
        }
    }

    @Override
    public final void init() throws RequiredArgumentMissingException {
        if (this.map == null || this.map.size() == 0) {
            throw new RequiredArgumentMissingException("Required argument 'map' is missing or zero-size");
        }
        this.stageInit();
    }

    public abstract void stageInit() throws RequiredArgumentMissingException;

    public abstract void processField(LocalDocument var1, String var2, String var3) throws ProcessException;
}

