/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.stage;

import com.findwise.hydra.local.LocalDocument;
import com.findwise.hydra.local.LocalQuery;
import com.findwise.hydra.stage.AbstractStage;
import com.findwise.hydra.stage.Parameter;
import com.findwise.hydra.stage.RequiredArgumentMissingException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStage
extends AbstractStage {
    Logger logger = LoggerFactory.getLogger(AbstractInputStage.class);
    @Parameter
    protected String idField;
    @Parameter
    protected boolean discardOldDocuments = true;

    @Override
    public void run() {
        this.setContinueRunning(true);
        while (this.isContinueRunning()) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                this.logger.error("Caught exception while running", (Throwable)e);
                Runtime.getRuntime().removeShutdownHook(this.getShutDownHook());
                System.exit(1);
            }
        }
    }

    protected void discardOld(LocalDocument ld) throws RequiredArgumentMissingException {
        if (!this.discardOldDocuments) {
            return;
        }
        if (this.idField == null) {
            throw new RequiredArgumentMissingException("Input stage is set to discard old documents but idField is not specified.");
        }
        this.logger.debug("idField: " + this.idField + " value: " + ld.getContentField(this.idField));
        this.discardDocumentsWithValue(this.idField, ld.getContentField(this.idField));
    }

    private void discardDocumentsWithValue(String fieldName, Object fieldValue) {
        this.logger.debug("Discard");
        LocalQuery lq = new LocalQuery();
        lq.requireContentFieldEquals(fieldName, fieldValue);
        this.logger.debug("Local query is: " + lq.toJson());
        try {
            LocalDocument ld = this.getRemotePipeline().getDocument(lq);
            while (ld != null) {
                this.logger.debug("Found document: " + ld.getID());
                this.getRemotePipeline().markDiscarded(ld);
                this.logger.debug("Discarded document: " + ld.toJson());
                ld = this.getRemotePipeline().getDocument(lq);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException while trying to discard");
            throw new RuntimeException(e);
        }
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public boolean isDiscardOldDocuments() {
        return this.discardOldDocuments;
    }

    public void setDiscardOldDocuments(boolean discardOldDocuments) {
        this.discardOldDocuments = discardOldDocuments;
    }
}

