/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.local;

import com.findwise.hydra.DocumentFile;
import com.findwise.hydra.DocumentID;
import com.findwise.hydra.JsonException;
import com.findwise.hydra.SerializationUtils;
import com.findwise.hydra.local.Local;
import com.findwise.hydra.local.LocalDocument;
import com.findwise.hydra.local.LocalDocumentID;
import com.findwise.hydra.local.LocalQuery;
import com.findwise.tools.HttpConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePipeline {
    private static final Logger internalLogger = LoggerFactory.getLogger((String)"internal");
    private static final Logger logger = LoggerFactory.getLogger(RemotePipeline.class);
    public static final String GET_DOCUMENT_URL = "getDocument";
    public static final String WRITE_DOCUMENT_URL = "writeDocument";
    public static final String RELEASE_DOCUMENT_URL = "releaseDocument";
    public static final String PROCESSED_DOCUMENT_URL = "processedDocument";
    public static final String PENDING_DOCUMENT_URL = "pendingDocument";
    public static final String DISCARDED_DOCUMENT_URL = "discardedDocument";
    public static final String GET_PROPERTIES_URL = "getProperties";
    public static final String FAILED_DOCUMENT_URL = "failedDocument";
    public static final String FILE_URL = "documentFile";
    public static final String STAGE_PARAM = "stage";
    public static final String NORELEASE_PARAM = "norelease";
    public static final String PARTIAL_PARAM = "partial";
    public static final String DOCID_PARAM = "docid";
    public static final String FILENAME_PARAM = "filename";
    public static final int DEFAULT_PORT = 12001;
    public static final String DEFAULT_HOST = "127.0.0.1";
    private boolean performanceLogging = false;
    private HttpConnection core;
    private boolean keepLock;
    private String getUrl;
    private String writeUrl;
    private String releaseUrl;
    private String processedUrl;
    private String failedUrl;
    private String pendingUrl;
    private String discardedUrl;
    private String propertyUrl;
    private String fileUrl;
    private String stageName;
    private LocalDocument currentDocument;

    public RemotePipeline(String stageName) {
        this(DEFAULT_HOST, 12001, stageName);
    }

    public RemotePipeline(String hostName, int port, String stageName) {
        this.stageName = stageName;
        this.getUrl = "/getDocument?stage=" + stageName;
        this.writeUrl = "/writeDocument?stage=" + stageName;
        this.releaseUrl = "/releaseDocument?stage=" + stageName;
        this.processedUrl = "/processedDocument?stage=" + stageName;
        this.failedUrl = "/failedDocument?stage=" + stageName;
        this.pendingUrl = "/pendingDocument?stage=" + stageName;
        this.discardedUrl = "/discardedDocument?stage=" + stageName;
        this.propertyUrl = "/getProperties?stage=" + stageName;
        this.fileUrl = "/documentFile?stage=" + stageName;
        this.keepLock = false;
        this.core = new HttpConnection(hostName, port);
    }

    public LocalDocument getDocument(LocalQuery query) throws IOException {
        long start = System.currentTimeMillis();
        HttpResponse response = this.core.post(this.getUrl, query.toJson());
        long startSerialize = System.currentTimeMillis();
        long startJson = 0L;
        LocalDocument ld = null;
        if (response.getStatusLine().getStatusCode() == 200) {
            String s = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                startJson = System.currentTimeMillis();
                ld = new LocalDocument(s);
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
            internalLogger.debug("Received document with ID " + ld.getID());
            this.currentDocument = ld;
        } else if (response.getStatusLine().getStatusCode() == 404) {
            internalLogger.debug("No document found matching query");
            EntityUtils.consume((HttpEntity)response.getEntity());
        } else {
            RemotePipeline.logUnexpected(response);
        }
        if (this.isPerformanceLogging()) {
            long end = System.currentTimeMillis();
            LocalDocumentID docId = ld != null ? ld.getID() : null;
            logger.info(String.format("type=performance event=query stage_name=%s doc_id=\"%s\" start=%d fetch=%d entitystring=%d serialize=%d end=%d total=%d", this.stageName, docId, start, startSerialize - start, startJson - startSerialize, end - startJson, end, end - start));
        }
        return ld;
    }

    public boolean releaseLastDocument() throws IOException {
        if (this.currentDocument == null) {
            internalLogger.debug("There is no document to release...");
            return false;
        }
        HttpResponse response = this.core.post(this.releaseUrl, this.currentDocument.contentFieldsToJson(null));
        this.currentDocument = null;
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    private static void logUnexpected(HttpResponse response) throws IOException {
        internalLogger.error("Node gave an unexpected response: " + response.getStatusLine());
        internalLogger.error("Message: " + EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public void keepLock() {
        this.keepLock = true;
    }

    public boolean saveCurrentDocument() throws IOException, JsonException {
        boolean keepingLock = this.keepLock;
        if (this.currentDocument == null) {
            internalLogger.error("There is no document to write.");
            return false;
        }
        boolean x = this.save(this.currentDocument);
        if (x && !keepingLock) {
            this.currentDocument = null;
        }
        return x;
    }

    public boolean saveFull(LocalDocument d) throws IOException, JsonException {
        boolean res = this.save(d, false);
        if (res) {
            d.markSynced();
            this.keepLock = false;
        }
        return res;
    }

    public boolean save(LocalDocument d) throws IOException, JsonException {
        boolean res = this.save(d, true);
        if (res) {
            d.markSynced();
            this.keepLock = false;
        }
        return res;
    }

    private boolean save(LocalDocument d, boolean partialUpdate) throws IOException, JsonException {
        boolean hasId = d.getID() != null;
        long start = System.currentTimeMillis();
        String s = partialUpdate ? d.modifiedFieldsToJson() : d.toJson();
        long startPost = System.currentTimeMillis();
        HttpResponse response = this.core.post(this.getWriteUrl(partialUpdate), s);
        if (response.getStatusLine().getStatusCode() == 200) {
            if (!hasId) {
                LocalDocument updated = new LocalDocument(EntityUtils.toString((HttpEntity)response.getEntity()));
                d.putAll(updated);
            } else {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (this.isPerformanceLogging()) {
                long end = System.currentTimeMillis();
                LocalDocumentID docId = d.getID();
                logger.info(String.format("type=performance event=update stage_name=%s doc_id=\"%s\" start=%d serialize=%d post=%d end=%d total=%d", this.stageName, docId, start, startPost - start, end - startPost, end, end - start));
            }
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public boolean markPending(LocalDocument d) throws IOException {
        HttpResponse response = this.core.post(this.pendingUrl, d.contentFieldsToJson(null));
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public boolean markFailed(LocalDocument d) throws IOException {
        HttpResponse response = this.core.post(this.failedUrl, d.modifiedFieldsToJson());
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public boolean markFailed(LocalDocument d, Throwable t) throws IOException {
        d.addError(this.stageName, t);
        return this.markFailed(d);
    }

    public boolean markProcessed(LocalDocument d) throws IOException {
        HttpResponse response = this.core.post(this.processedUrl, d.modifiedFieldsToJson());
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public boolean markDiscarded(LocalDocument d) throws IOException {
        HttpResponse response = this.core.post(this.discardedUrl, d.modifiedFieldsToJson());
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    private String getWriteUrl(boolean partialUpdate) {
        String s = this.writeUrl;
        s = this.keepLock ? s + "&norelease=1" : s + "&norelease=0";
        s = partialUpdate ? s + "&partial=1" : s + "&partial=0";
        return s;
    }

    public Map<String, Object> getProperties() throws IOException {
        HttpResponse response = this.core.get(this.propertyUrl);
        if (response.getStatusLine().getStatusCode() == 200) {
            Map<String, Object> map;
            try {
                map = SerializationUtils.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
            internalLogger.debug("Successfully retrieved propertyMap with " + map.size() + " entries");
            return map;
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            internalLogger.debug("No document found matching query");
            EntityUtils.consume((HttpEntity)response.getEntity());
            return null;
        }
        RemotePipeline.logUnexpected(response);
        return null;
    }

    private String getFileUrl(DocumentFile<Local> df) throws UnsupportedEncodingException {
        return this.getFileUrl(df.getFileName(), df.getDocumentId());
    }

    private String getFileUrl(String fileName, DocumentID<Local> docid) throws UnsupportedEncodingException {
        return this.fileUrl + "&" + FILENAME_PARAM + "=" + fileName + "&" + DOCID_PARAM + "=" + URLEncoder.encode(docid.toJSON(), "UTF-8");
    }

    public DocumentFile<Local> getFile(String fileName, DocumentID<Local> docid) throws IOException {
        HttpResponse response = this.core.get(this.getFileUrl(fileName, docid));
        if (response.getStatusLine().getStatusCode() == 200) {
            Object o;
            try {
                o = SerializationUtils.toObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
            if (!(o instanceof Map)) {
                return null;
            }
            Map map = (Map)o;
            Date d = (Date)map.get("uploadDate");
            String encoding = (String)map.get("encoding");
            String mimetype = (String)map.get("mimetype");
            String savedByStage = (String)map.get("savedByStage");
            ByteArrayInputStream is = encoding == null ? new ByteArrayInputStream(Base64.decodeBase64((byte[])((String)map.get("stream")).getBytes("UTF-8"))) : new ByteArrayInputStream(Base64.decodeBase64((byte[])((String)map.get("stream")).getBytes(encoding)));
            DocumentFile<Local> df = new DocumentFile<Local>(docid, fileName, is, savedByStage, d);
            df.setEncoding(encoding);
            df.setMimetype(mimetype);
            return df;
        }
        RemotePipeline.logUnexpected(response);
        return null;
    }

    public boolean saveFile(DocumentFile<Local> df) throws IOException {
        HttpResponse response = this.core.post(this.getFileUrl(df), SerializationUtils.toJson(df));
        int code = response.getStatusLine().getStatusCode();
        if (code == 200 || code == 204) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public boolean deleteFile(String fileName, DocumentID<Local> docid) throws IOException {
        HttpResponse response = this.core.delete(this.getFileUrl(fileName, docid));
        if (response.getStatusLine().getStatusCode() == 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        RemotePipeline.logUnexpected(response);
        return false;
    }

    public List<String> getFileNames(DocumentID<?> docid) throws IOException {
        HttpResponse response = this.core.get(this.fileUrl + "&" + DOCID_PARAM + "=" + URLEncoder.encode(docid.toJSON(), "UTF-8"));
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return (List)SerializationUtils.toObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }
        RemotePipeline.logUnexpected(response);
        return null;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }
}

