/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.local;

import com.findwise.hydra.Document;
import com.findwise.hydra.JsonDeserializer;
import com.findwise.hydra.JsonException;
import com.findwise.hydra.Query;
import com.findwise.hydra.SerializationUtils;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;

public class LocalQuery
implements Query,
JsonDeserializer {
    private Map<String, Object> equals = new HashMap<String, Object>();
    private Map<String, Object> notEquals = new HashMap<String, Object>();
    private Map<String, Boolean> exists = new HashMap<String, Boolean>();
    private Map<String, Boolean> touched = new HashMap<String, Boolean>();
    private Document.Action action = null;

    public LocalQuery() {
    }

    public LocalQuery(String json) throws JsonException {
        this();
        this.fromJson(json);
    }

    public Map<String, Boolean> getContentsExists() {
        return this.exists;
    }

    public Map<String, Boolean> getTouched() {
        return this.touched;
    }

    public Map<String, Object> getContentsEquals() {
        return this.equals;
    }

    public Map<String, Object> getEquals() {
        return this.equals;
    }

    public Map<String, Object> getContentNotEquals() {
        return this.notEquals;
    }

    public Map<String, Object> getNotEquals() {
        return this.notEquals;
    }

    public Map<String, Boolean> getExists() {
        return this.exists;
    }

    public Document.Action getAction() {
        return this.action;
    }

    @Override
    public void requireContentFieldExists(String fieldName) {
        this.getContentsExists().put(fieldName, true);
    }

    @Override
    public void requireContentFieldNotExists(String fieldName) {
        this.getContentsExists().put(fieldName, false);
    }

    @Override
    public void requireContentFieldEquals(String fieldName, Object o) {
        this.getContentsEquals().put(fieldName, o);
    }

    @Override
    public void requireContentFieldNotEquals(String fieldName, Object o) {
        this.getContentNotEquals().put(fieldName, o);
    }

    @Override
    public void requireTouchedByStage(String stageName) {
        this.getTouched().put(stageName, true);
    }

    @Override
    public void requireNotTouchedByStage(String stageName) {
        this.getTouched().put(stageName, false);
    }

    @Override
    public void requireAction(Document.Action action) {
        this.action = action;
    }

    @Override
    public String toJson() {
        HashMap<String, Object> x = new HashMap<String, Object>();
        x.put("equals", this.equals);
        x.put("notEquals", this.notEquals);
        x.put("exists", this.exists);
        x.put("touched", this.touched);
        if (this.action != null) {
            x.put("action", this.action.toString());
        }
        return SerializationUtils.toJson(x);
    }

    @Override
    public void fromJson(String json) throws JsonException {
        try {
            Map<String, Object> queryObject = SerializationUtils.fromJson(json);
            if (queryObject.containsKey("equals")) {
                this.equals = (Map)queryObject.get("equals");
            }
            if (queryObject.containsKey("notEquals")) {
                this.notEquals = (Map)queryObject.get("notEquals");
            }
            if (queryObject.containsKey("exists")) {
                this.exists = (Map)queryObject.get("exists");
            }
            if (queryObject.containsKey("touched")) {
                this.touched = (Map)queryObject.get("touched");
            }
            if (queryObject.containsKey("action")) {
                this.action = Document.Action.valueOf((String)queryObject.get("action"));
            }
        }
        catch (JsonParseException jse) {
            throw new JsonException(jse);
        }
    }

    public String toString() {
        return this.toJson();
    }
}

