/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra.local;

import com.findwise.hydra.Document;
import com.findwise.hydra.DocumentID;
import com.findwise.hydra.JsonException;
import com.findwise.hydra.SerializationUtils;
import com.findwise.hydra.local.Local;
import com.findwise.hydra.local.LocalDocumentID;
import com.findwise.tools.Comparator;
import com.google.gson.JsonParseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDocument
implements Document<Local> {
    private static Logger internalLogger = LoggerFactory.getLogger((String)"internal");
    private Map<String, Object> documentMap = new HashMap<String, Object>();
    private Set<String> touchedContent;
    private Set<String> touchedMetadata;
    private boolean touchedAction;

    public LocalDocument() {
        this.documentMap.put("contents", new HashMap());
        this.documentMap.put("metadata", new HashMap());
        this.touchedContent = new HashSet<String>();
        this.touchedMetadata = new HashSet<String>();
        this.touchedAction = false;
    }

    public LocalDocument(String json) throws JsonException {
        this();
        this.fromJson(json);
        this.markSynced();
    }

    @Override
    public Document.Action getAction() {
        return (Document.Action)((Object)this.documentMap.get("_action"));
    }

    @Override
    public void setAction(Document.Action action) {
        this.documentMap.put("_action", (Object)action);
        this.touchedAction = true;
    }

    public final void markSynced() {
        this.touchedContent.clear();
        this.touchedMetadata.clear();
        this.touchedAction = false;
    }

    public boolean isSynced() {
        return this.touchedContent.size() + this.touchedMetadata.size() == 0 && !this.touchedAction;
    }

    @Override
    public boolean hasContentField(String fieldName) {
        return this.getContentMap().containsKey(fieldName) && this.getContentMap().get(fieldName) != null;
    }

    @Override
    public boolean hasMetadataField(String fieldName) {
        return ((Map)this.documentMap.get("metadata")).containsKey(fieldName);
    }

    public LocalDocumentID getID() {
        if (!this.documentMap.containsKey("_id")) {
            return null;
        }
        return new LocalDocumentID(this.documentMap.get("_id"));
    }

    public void setID(DocumentID<Local> id) {
        this.documentMap.put("_id", id.getID());
    }

    @Override
    public Map<String, Object> getContentMap() {
        return (Map)this.documentMap.get("contents");
    }

    @Override
    public Map<String, Object> getMetadataMap() {
        return (Map)this.documentMap.get("metadata");
    }

    @Override
    public final Object putContentField(String fieldName, Object value) {
        fieldName = this.removePeriodFromKey(fieldName);
        this.touchedContent.add(fieldName);
        return this.getContentMap().put(fieldName, value);
    }

    private Object putMetadataField(String fieldName, Object value) {
        fieldName = this.removePeriodFromKey(fieldName);
        this.touchedMetadata.add(fieldName);
        return this.getMetadataMap().put(fieldName, value);
    }

    @Override
    public Object getContentField(String fieldName) {
        return this.getContentMap().get(fieldName);
    }

    private Object getMetadataField(String fieldName) {
        return this.getMetadataMap().get(fieldName);
    }

    private Set<String> getMetadataFields() {
        return this.getMetadataMap().keySet();
    }

    @Override
    public Set<String> getContentFields() {
        HashSet<String> set = new HashSet<String>(this.getContentMap().keySet());
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            if (this.hasContentField(it.next())) continue;
            it.remove();
        }
        return set;
    }

    @Override
    public boolean hasErrors() {
        return this.getMetadataMap().containsKey("error");
    }

    @Override
    public void addError(String from, Throwable t) {
        if (!this.hasErrors()) {
            this.getMetadataMap().put("error", new HashMap());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        ((HashMap)this.getMetadataMap().get("error")).put(from, sw.toString());
        this.touchedMetadata.add("error");
    }

    @Override
    public final void fromJson(String json) throws JsonException {
        try {
            Map<String, Object> m = SerializationUtils.fromJson(json);
            if (m.containsKey("_id")) {
                this.documentMap.put("_id", m.get("_id"));
            }
            if (m.containsKey("_action") && m.get("_action") != null) {
                this.documentMap.put("_action", (Object)Document.Action.valueOf((String)m.get("_action")));
            }
            if (m.containsKey("metadata")) {
                Map metadata = (Map)m.get("metadata");
                for (Map.Entry e : metadata.entrySet()) {
                    this.putMetadataField((String)e.getKey(), metadata.get(e.getKey()));
                }
            }
            if (m.containsKey("contents")) {
                Map content = (Map)m.get("contents");
                for (Map.Entry e : content.entrySet()) {
                    this.putContentField((String)e.getKey(), content.get(e.getKey()));
                }
            }
        }
        catch (JsonParseException e) {
            internalLogger.error("Caught JsonParseException, throwing JsonException");
            throw new JsonException(e);
        }
    }

    private String removePeriodFromKey(String key) {
        if (key.contains(".")) {
            internalLogger.warn("The fieldname " + key + " contains a period, mongodb does not allow keys to contain a period (.). It has been replaced with a dash (-)");
            return key.replace(".", "-");
        }
        return key;
    }

    @Override
    public void putAll(Document<?> d) {
        if (d.getID() != null) {
            this.documentMap.put("_id", d.getID().getID());
        }
        if (d.getAction() != null) {
            this.documentMap.put("_action", (Object)d.getAction());
        }
        for (Map.Entry<String, Object> e : d.getMetadataMap().entrySet()) {
            this.putMetadataField(e.getKey(), e.getValue());
        }
        for (String s : d.getContentFields()) {
            this.putContentField(s, d.getContentField(s));
        }
    }

    @Override
    public String toJson() {
        return SerializationUtils.toJson(this.documentMap);
    }

    protected Map<String, Object> getDocumentMap() {
        return this.documentMap;
    }

    @Override
    public boolean isEqual(Document<?> d) {
        if (d.getID() != null ? !d.getID().equals(this.getID()) : this.getID() != null) {
            return false;
        }
        if (d.getAction() != this.getAction()) {
            return false;
        }
        return this.equalMetadata(d) && this.equalContent(d);
    }

    private boolean equalMetadata(Document<?> d) {
        Set<String> metadata = this.getMetadataMap().keySet();
        if (metadata.size() != this.getMetadataFields().size()) {
            return false;
        }
        for (String s : metadata) {
            if (!this.getMetadataFields().contains(s)) {
                return false;
            }
            if (Comparator.equals(this.getMetadataField(s), d.getMetadataMap().get(s))) continue;
            return false;
        }
        return true;
    }

    private boolean equalContent(Document<?> d) {
        Set<String> content = d.getContentFields();
        if (content.size() != this.getContentFields().size()) {
            return false;
        }
        for (String s : content) {
            if (!this.getContentFields().contains(s)) {
                return false;
            }
            if (Comparator.equals(this.getContentField(s), d.getContentField(s))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String contentFieldsToJson(Iterable<String> contentFields) {
        return this.fieldsToJson(contentFields, null);
    }

    @Override
    public String metadataFieldsToJson(Iterable<String> metadataFields) {
        return this.fieldsToJson(null, metadataFields);
    }

    public String modifiedFieldsToJson() {
        return this.fieldsToJson(this.touchedContent, this.touchedMetadata);
    }

    private String fieldsToJson(Iterable<String> contentFields, Iterable<String> metadataFields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getID() != null) {
            map.put("_id", this.getID().getID());
        } else {
            map.put("_id", null);
        }
        if (contentFields != null) {
            HashMap<String, Object> cmap = new HashMap<String, Object>();
            for (String s : contentFields) {
                cmap.put(s, this.getContentField(s));
            }
            map.put("contents", cmap);
        }
        if (metadataFields != null) {
            HashMap<String, Object> mmap = new HashMap<String, Object>();
            for (String s : metadataFields) {
                mmap.put(s, this.getMetadataField(s));
            }
            map.put("metadata", mmap);
        }
        if (this.touchedAction) {
            map.put("_action", (Object)this.getAction());
        }
        return SerializationUtils.toJson(map);
    }

    public Map<String, Object> toMap() {
        return this.documentMap;
    }

    @Override
    public void clear() {
        this.documentMap.clear();
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public Document.Status getStatus() {
        if (this.getMetadataMap().containsKey("failed")) {
            return Document.Status.FAILED;
        }
        if (this.getMetadataMap().containsKey("discarded")) {
            return Document.Status.DISCARDED;
        }
        if (this.getMetadataMap().containsKey("pending")) {
            return Document.Status.PENDING;
        }
        if (this.getMetadataMap().containsKey("processed")) {
            return Document.Status.PROCESSED;
        }
        return Document.Status.PROCESSING;
    }

    public Set<String> getTouchedContent() {
        return this.touchedContent;
    }

    public Set<String> getTouchedMetadata() {
        return this.touchedMetadata;
    }

    public boolean isTouchedAction() {
        return this.touchedAction;
    }

    @Override
    public Object removeContentField(String key) {
        return this.putContentField(key, null);
    }
}

