/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra;

import com.findwise.hydra.DocumentID;
import com.findwise.hydra.JsonException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static Logger logger = LoggerFactory.getLogger(SerializationUtils.class);
    private static Logger internalLogger = LoggerFactory.getLogger((String)"internal");
    private static Gson gson = SerializationUtils.getGson();

    private static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    private static Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(InputStream.class, (Object)new JsonSerializer<InputStream>(){

            public JsonElement serialize(InputStream src, Type typeOfSrc, JsonSerializationContext context) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int b;
                    while ((b = src.read()) >= 0) {
                        baos.write(b);
                    }
                }
                catch (IOException e) {
                    logger.error("Caught IOException in Stream serialization", (Throwable)e);
                }
                return new JsonPrimitive(new String(Base64.encodeBase64((byte[])baos.toByteArray())));
            }
        });
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return src == null ? null : new JsonPrimitive(SerializationUtils.getDateFormat().format(src));
            }
        });
        gsonBuilder.registerTypeAdapter(DocumentID.class, (Object)new JsonSerializer<DocumentID<?>>(){

            public JsonElement serialize(DocumentID<?> src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                String json = src.toJSON();
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = json.substring(1, json.length() - 1);
                }
                return new JsonPrimitive(json);
            }
        });
        return gsonBuilder.serializeNulls().create();
    }

    private SerializationUtils() {
    }

    public static Map<String, Object> fromJson(String json) throws JsonException {
        try {
            Object o = SerializationUtils.toObject(json);
            if (o instanceof Map) {
                return (Map)o;
            }
            HashMap<String, Object> x = new HashMap<String, Object>();
            x.put("", o);
            return x;
        }
        catch (JsonParseException e) {
            throw new JsonException(e);
        }
    }

    public static Object toObject(String json) throws JsonException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        gsonBuilder.registerTypeAdapter(Object.class, (Object)new NaturalGsonDeserializer());
        Gson gson = gsonBuilder.create();
        return gson.fromJson(json, Object.class);
    }

    public static String toJson(Object o) {
        while (true) {
            try {
                return gson.toJson(o);
            }
            catch (ConcurrentModificationException e) {
                logger.warn("A ConcurrentModificationException was caught during serialization. Trying again!");
                continue;
            }
            break;
        }
    }

    public static Class<?> getResultingClass(Object o) {
        return SerializationUtils.getResultingClass(SerializationUtils.toJson(o));
    }

    public static Class<?> getResultingClass(String json) {
        try {
            return SerializationUtils.toObject(json).getClass();
        }
        catch (JsonException e) {
            return null;
        }
    }

    private static class NaturalGsonDeserializer
    implements JsonDeserializer<Object> {
        private NaturalGsonDeserializer() {
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                if (json.isJsonNull()) {
                    return null;
                }
                if (json.isJsonPrimitive()) {
                    return this.handlePrimitive(json.getAsJsonPrimitive());
                }
                if (json.isJsonArray()) {
                    return this.handleArray(json.getAsJsonArray(), context);
                }
                return this.handleObject(json.getAsJsonObject(), context);
            }
            catch (Exception e) {
                internalLogger.error("An exception was caught during deserialization", (Throwable)e);
                return null;
            }
        }

        private Object handlePrimitive(JsonPrimitive json) {
            if (json.isBoolean()) {
                return json.getAsBoolean();
            }
            if (json.isString()) {
                try {
                    return SerializationUtils.getDateFormat().parse(json.getAsString());
                }
                catch (ParseException e) {
                    return json.getAsString();
                }
            }
            BigDecimal bigDec = json.getAsBigDecimal();
            try {
                bigDec.toBigIntegerExact();
                try {
                    return bigDec.intValueExact();
                }
                catch (ArithmeticException e) {
                    return bigDec.longValue();
                }
            }
            catch (ArithmeticException arithmeticException) {
                return bigDec.doubleValue();
            }
        }

        private Object handleArray(JsonArray json, JsonDeserializationContext context) {
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < json.size(); ++i) {
                array.add(context.deserialize(json.get(i), Object.class));
            }
            return array;
        }

        private Object handleObject(JsonObject json, JsonDeserializationContext context) {
            try {
                HashMap map = new HashMap();
                for (Map.Entry entry : json.entrySet()) {
                    map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), Object.class));
                }
                return map;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

