/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.LoggerFactory;

public class Logging {
    private static LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static boolean remoteLoggerActive = false;

    public static synchronized void setup(String host, int port) throws UnknownHostException {
        if (remoteLoggerActive) {
            return;
        }
        remoteLoggerActive = true;
        lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        SocketAppender socketAppender = new SocketAppender(InetAddress.getByName(host), port);
        socketAppender.setContext((Context)lc);
        socketAppender.start();
        Logger rootLogger = Logging.getRootLogger();
        rootLogger.detachAndStopAllAppenders();
        rootLogger.addAppender((Appender)socketAppender);
        Logging.setInternalLoggingLevel(Level.WARN);
        Logging.setGlobalLoggingLevel(Level.TRACE);
    }

    public static synchronized void addConsoleAppender() {
        Logging.addConsoleAppender(Logging.getRootLogger());
    }

    public static synchronized void addConsoleAppender(Logger logger) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)logger.getLoggerContext());
        encoder.setPattern("%d{HH:mm:ss.SSS} [%-5level] %msg %n");
        encoder.start();
        ConsoleAppender c = new ConsoleAppender();
        c.setContext((Context)logger.getLoggerContext());
        c.setOutputStream((OutputStream)System.err);
        c.setEncoder((Encoder)encoder);
        c.start();
        logger.addAppender((Appender)c);
    }

    public static Level getInternalLogLevel() {
        return Logging.getInternalLogger().getLevel();
    }

    public static void setInternalLoggingLevel(Level loggingLevel) {
        Logging.getInternalLogger().setLevel(loggingLevel);
    }

    public static Level getGlobalLogLevel() {
        return Logging.getRootLogger().getLevel();
    }

    public static void setGlobalLoggingLevel(Level loggingLevel) {
        Logging.getRootLogger().setLevel(loggingLevel);
    }

    private static Logger getInternalLogger() {
        return lc.getLogger("internal");
    }

    private static Logger getRootLogger() {
        return lc.getLogger("ROOT");
    }
}

