/*
 * Decompiled with CFR 0.152.
 */
package com.findwise.hydra;

import com.findwise.hydra.DocumentID;
import com.findwise.hydra.JsonDeserializer;
import com.findwise.hydra.JsonException;
import com.findwise.hydra.JsonSerializer;
import java.util.Map;
import java.util.Set;

public interface Document<Type>
extends JsonDeserializer,
JsonSerializer {
    public static final String ID_KEY = "_id";
    public static final String ACTION_KEY = "_action";
    public static final String CONTENTS_KEY = "contents";
    public static final String METADATA_KEY = "metadata";
    public static final String COMMITTING_METADATA_FLAG = "committing";
    public static final String PENDING_METADATA_FLAG = "pending";
    public static final String PROCESSED_METADATA_FLAG = "processed";
    public static final String DISCARDED_METADATA_FLAG = "discarded";
    public static final String FETCHED_METADATA_TAG = "fetched";
    public static final String TOUCHED_METADATA_TAG = "touched";
    public static final String FAILED_METADATA_FLAG = "failed";
    public static final String DATE_METADATA_SUBKEY = "date";
    public static final String STAGE_METADATA_SUBKEY = "stage";
    public static final String ERROR_METADATA_KEY = "error";

    public Action getAction();

    public void setAction(Action var1);

    public Status getStatus();

    public boolean hasContentField(String var1);

    public boolean hasMetadataField(String var1);

    public DocumentID<Type> getID();

    public Object putContentField(String var1, Object var2);

    public Object getContentField(String var1);

    public Map<String, Object> getMetadataMap();

    public Map<String, Object> getContentMap();

    public void addError(String var1, Throwable var2);

    public boolean hasErrors();

    public Set<String> getContentFields();

    public void putAll(Document<?> var1);

    public boolean isEqual(Document<?> var1);

    public Object removeContentField(String var1);

    public void clear();

    @Override
    public void fromJson(String var1) throws JsonException;

    @Override
    public String toJson();

    public String contentFieldsToJson(Iterable<String> var1);

    public String metadataFieldsToJson(Iterable<String> var1);

    public static enum Status {
        PROCESSING,
        PROCESSED,
        DISCARDED,
        FAILED,
        PENDING;

    }

    public static enum Action {
        ADD,
        DELETE,
        UPDATE;

    }
}

