/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.websocket;

import com.facebook.stetho.websocket.Frame;
import com.facebook.stetho.websocket.FrameHelper;
import com.facebook.stetho.websocket.ReadCallback;
import com.facebook.stetho.websocket.ReadHandler;
import com.facebook.stetho.websocket.SimpleEndpoint;
import com.facebook.stetho.websocket.SimpleSession;
import com.facebook.stetho.websocket.WriteCallback;
import com.facebook.stetho.websocket.WriteHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

class WebSocketSession
implements SimpleSession {
    private final ReadHandler mReadHandler;
    private final WriteHandler mWriteHandler;
    private final SimpleEndpoint mEndpoint;
    private AtomicBoolean mIsOpen = new AtomicBoolean(false);
    private volatile boolean mSentClose;
    private final ReadCallback mReadCallback = new ReadCallback(){

        @Override
        public void onCompleteFrame(byte opcode, byte[] payload, int payloadLen) {
            switch (opcode) {
                case 8: {
                    this.handleClose(payload, payloadLen);
                    break;
                }
                case 9: {
                    this.handlePing(payload, payloadLen);
                    break;
                }
                case 10: {
                    this.handlePong(payload, payloadLen);
                    break;
                }
                case 1: {
                    this.handleTextFrame(payload, payloadLen);
                    break;
                }
                case 2: {
                    this.handleBinaryFrame(payload, payloadLen);
                    break;
                }
                default: {
                    WebSocketSession.this.signalError(new IOException("Unsupported frame opcode=" + opcode));
                }
            }
        }

        private void handleClose(byte[] payload, int payloadLen) {
            String closeReasonPhrase;
            int closeCode;
            if (payloadLen >= 2) {
                closeCode = (payload[0] & 0xFF) << 8 | payload[1] & 0xFF;
                closeReasonPhrase = payloadLen > 2 ? new String(payload, 2, payloadLen - 2) : null;
            } else {
                closeCode = 1006;
                closeReasonPhrase = "Unparseable close frame";
            }
            if (!WebSocketSession.this.mSentClose) {
                WebSocketSession.this.sendClose(1000, "Received close frame");
            }
            WebSocketSession.this.markAndSignalClosed(closeCode, closeReasonPhrase);
        }

        private void handlePing(byte[] payload, int payloadLen) {
            WebSocketSession.this.doWrite(FrameHelper.createPongFrame(payload, payloadLen));
        }

        private void handlePong(byte[] payload, int payloadLen) {
        }

        private void handleTextFrame(byte[] payload, int payloadLen) {
            WebSocketSession.this.mEndpoint.onMessage(WebSocketSession.this, new String(payload, 0, payloadLen));
        }

        private void handleBinaryFrame(byte[] payload, int payloadLen) {
            WebSocketSession.this.mEndpoint.onMessage(WebSocketSession.this, payload, payloadLen);
        }
    };
    private final WriteCallback mErrorForwardingWriteCallback = new WriteCallback(){

        @Override
        public void onFailure(IOException e) {
            WebSocketSession.this.signalError(e);
        }

        @Override
        public void onSuccess() {
        }
    };

    public WebSocketSession(InputStream rawSocketInput, OutputStream rawSocketOutput, SimpleEndpoint endpoint) {
        this.mReadHandler = new ReadHandler(rawSocketInput, endpoint);
        this.mWriteHandler = new WriteHandler(rawSocketOutput);
        this.mEndpoint = endpoint;
    }

    public void handle() throws IOException {
        this.markAndSignalOpen();
        try {
            this.mReadHandler.readLoop(this.mReadCallback);
        }
        catch (EOFException e) {
            this.markAndSignalClosed(1011, "EOF while reading");
        }
        catch (IOException e) {
            this.markAndSignalClosed(1006, null);
            throw e;
        }
    }

    @Override
    public void sendText(String payload) {
        this.doWrite(FrameHelper.createTextFrame(payload));
    }

    @Override
    public void sendBinary(byte[] payload) {
        this.doWrite(FrameHelper.createBinaryFrame(payload));
    }

    @Override
    public void close(int closeReason, String reasonPhrase) {
        this.sendClose(closeReason, reasonPhrase);
        this.markAndSignalClosed(closeReason, reasonPhrase);
    }

    private void sendClose(int closeReason, String reasonPhrase) {
        this.doWrite(FrameHelper.createCloseFrame(closeReason, reasonPhrase));
        this.markSentClose();
    }

    void markSentClose() {
        this.mSentClose = true;
    }

    void markAndSignalOpen() {
        if (!this.mIsOpen.getAndSet(true)) {
            this.mEndpoint.onOpen(this);
        }
    }

    void markAndSignalClosed(int closeReason, String reasonPhrase) {
        if (this.mIsOpen.getAndSet(false)) {
            this.mEndpoint.onClose(this, closeReason, reasonPhrase);
        }
    }

    @Override
    public boolean isOpen() {
        return this.mIsOpen.get();
    }

    private void doWrite(Frame frame) {
        if (this.signalErrorIfNotOpen()) {
            return;
        }
        this.mWriteHandler.write(frame, this.mErrorForwardingWriteCallback);
    }

    private boolean signalErrorIfNotOpen() {
        if (!this.isOpen()) {
            this.signalError(new IOException("Session is closed"));
            return true;
        }
        return false;
    }

    private void signalError(IOException e) {
        this.mEndpoint.onError(this, e);
    }
}

