/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.websocket;

import com.facebook.stetho.common.Utf8Charset;
import com.facebook.stetho.websocket.Frame;

class FrameHelper {
    FrameHelper() {
    }

    public static Frame createTextFrame(String payload) {
        return FrameHelper.createSimpleFrame((byte)1, Utf8Charset.encodeUTF8(payload));
    }

    public static Frame createBinaryFrame(byte[] payload) {
        return FrameHelper.createSimpleFrame((byte)2, payload);
    }

    public static Frame createCloseFrame(int closeCode, String reasonPhrase) {
        byte[] reasonPhraseEncoded = null;
        int payloadLen = 2;
        if (reasonPhrase != null) {
            reasonPhraseEncoded = Utf8Charset.encodeUTF8(reasonPhrase);
            payloadLen += reasonPhraseEncoded.length;
        }
        byte[] payload = new byte[payloadLen];
        payload[0] = (byte)(closeCode >> 8 & 0xFF);
        payload[1] = (byte)(closeCode & 0xFF);
        if (reasonPhraseEncoded != null) {
            System.arraycopy(reasonPhraseEncoded, 0, payload, 2, reasonPhraseEncoded.length);
        }
        return FrameHelper.createSimpleFrame((byte)8, payload);
    }

    public static Frame createPingFrame(byte[] payload, int payloadLen) {
        return FrameHelper.createSimpleFrame((byte)9, payload, payloadLen);
    }

    public static Frame createPongFrame(byte[] payload, int payloadLen) {
        return FrameHelper.createSimpleFrame((byte)10, payload, payloadLen);
    }

    private static Frame createSimpleFrame(byte opcode, byte[] payload) {
        return FrameHelper.createSimpleFrame(opcode, payload, payload.length);
    }

    private static Frame createSimpleFrame(byte opCode, byte[] payload, int payloadLen) {
        Frame frame = new Frame();
        frame.fin = true;
        frame.hasMask = false;
        frame.opcode = opCode;
        frame.payloadLen = payloadLen;
        frame.payloadData = payload;
        return frame;
    }
}

