/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.websocket;

import com.facebook.stetho.websocket.MaskingHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Frame {
    public static final byte OPCODE_TEXT_FRAME = 1;
    public static final byte OPCODE_BINARY_FRAME = 2;
    public static final byte OPCODE_CONNECTION_CLOSE = 8;
    public static final byte OPCODE_CONNECTION_PING = 9;
    public static final byte OPCODE_CONNECTION_PONG = 10;
    public boolean fin;
    public boolean rsv1;
    public boolean rsv2;
    public boolean rsv3;
    public byte opcode;
    public boolean hasMask;
    public long payloadLen;
    public byte[] maskingKey;
    public byte[] payloadData;

    Frame() {
    }

    public void readFrom(BufferedInputStream input) throws IOException {
        this.decodeFirstByte(Frame.readByteOrThrow(input));
        byte maskAndFirstLengthBits = Frame.readByteOrThrow(input);
        this.hasMask = (maskAndFirstLengthBits & 0x80) != 0;
        this.payloadLen = this.decodeLength((byte)(maskAndFirstLengthBits & 0xFFFFFF7F), input);
        this.maskingKey = this.hasMask ? Frame.decodeMaskingKey(input) : null;
        this.payloadData = new byte[(int)this.payloadLen];
        Frame.readBytesOrThrow(input, this.payloadData, 0, (int)this.payloadLen);
        MaskingHelper.unmask(this.maskingKey, this.payloadData, 0, (int)this.payloadLen);
    }

    public void writeTo(BufferedOutputStream output) throws IOException {
        output.write(this.encodeFirstByte());
        byte[] lengthAndMaskBit = Frame.encodeLength(this.payloadLen);
        if (this.hasMask) {
            lengthAndMaskBit[0] = (byte)(lengthAndMaskBit[0] | 0x80);
        }
        output.write(lengthAndMaskBit, 0, lengthAndMaskBit.length);
        if (this.hasMask) {
            throw new UnsupportedOperationException("Writing masked data not implemented");
        }
        output.write(this.payloadData, 0, (int)this.payloadLen);
    }

    private void decodeFirstByte(byte b) {
        this.fin = (b & 0x80) != 0;
        this.rsv1 = (b & 0x40) != 0;
        this.rsv2 = (b & 0x20) != 0;
        this.rsv3 = (b & 0x10) != 0;
        this.opcode = (byte)(b & 0xF);
    }

    private byte encodeFirstByte() {
        byte b = 0;
        if (this.fin) {
            b = (byte)(b | 0x80);
        }
        if (this.rsv1) {
            b = (byte)(b | 0x40);
        }
        if (this.rsv2) {
            b = (byte)(b | 0x20);
        }
        if (this.rsv3) {
            b = (byte)(b | 0x10);
        }
        b = (byte)(b | this.opcode & 0xF);
        return b;
    }

    private long decodeLength(byte firstLenByte, InputStream in) throws IOException {
        if (firstLenByte <= 125) {
            return firstLenByte;
        }
        if (firstLenByte == 126) {
            return (Frame.readByteOrThrow(in) & 0xFF) << 8 | Frame.readByteOrThrow(in) & 0xFF;
        }
        if (firstLenByte == 127) {
            long len = 0L;
            for (int i = 0; i < 8; ++i) {
                len |= (long)(Frame.readByteOrThrow(in) & 0xFF);
                len <<= 8;
            }
            return len;
        }
        throw new IOException("Unexpected length byte: " + firstLenByte);
    }

    private static byte[] encodeLength(long len) {
        if (len <= 125L) {
            return new byte[]{(byte)len};
        }
        if (len <= 65535L) {
            return new byte[]{126, (byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)};
        }
        return new byte[]{127, (byte)(len >> 56 & 0xFFL), (byte)(len >> 48 & 0xFFL), (byte)(len >> 40 & 0xFFL), (byte)(len >> 32 & 0xFFL), (byte)(len >> 24 & 0xFFL), (byte)(len >> 16 & 0xFFL), (byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)};
    }

    private static byte[] decodeMaskingKey(InputStream in) throws IOException {
        byte[] key = new byte[4];
        Frame.readBytesOrThrow(in, key, 0, key.length);
        return key;
    }

    private static void readBytesOrThrow(InputStream in, byte[] buf, int offset, int count) throws IOException {
        while (count > 0) {
            int n = in.read(buf, offset, count);
            if (n == -1) {
                throw new EOFException();
            }
            count -= n;
            offset += n;
        }
    }

    private static byte readByteOrThrow(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }
}

