/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.websocket;

import com.facebook.stetho.common.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class CompositeInputStream
extends InputStream {
    private final InputStream[] mStreams;
    private int mCurrentIndex;

    public CompositeInputStream(InputStream[] streams) {
        if (streams == null || streams.length < 2) {
            throw new IllegalArgumentException("Streams must be non-null and have more than 1 entry");
        }
        this.mStreams = streams;
        this.mCurrentIndex = 0;
    }

    @Override
    public int available() throws IOException {
        return this.mStreams[this.mCurrentIndex].available();
    }

    @Override
    public void close() throws IOException {
        this.closeAll(this.mCurrentIndex);
    }

    private void closeAll(int mostImportantIndex) throws IOException {
        IOException exceptionToThrow = null;
        for (int i = 0; i < this.mStreams.length; ++i) {
            try {
                this.mStreams[i].close();
                continue;
            }
            catch (IOException e) {
                IOException previousException = exceptionToThrow;
                if (i == mostImportantIndex || exceptionToThrow == null) {
                    exceptionToThrow = e;
                }
                if (previousException == null || previousException == exceptionToThrow) continue;
                LogUtil.w(previousException, "Suppressing exception");
            }
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int n;
        while ((n = this.mStreams[this.mCurrentIndex].read(buffer, byteOffset, byteCount)) == -1 && this.tryMoveToNextStream()) {
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        int b;
        while ((b = this.mStreams[this.mCurrentIndex].read()) == -1 && this.tryMoveToNextStream()) {
        }
        return b;
    }

    private boolean tryMoveToNextStream() {
        if (this.mCurrentIndex + 1 < this.mStreams.length) {
            ++this.mCurrentIndex;
            return true;
        }
        return false;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        byte[] buf = new byte[(int)byteCount];
        int n = this.read(buf);
        return n >= 0 ? (long)n : -1L;
    }
}

