/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.server;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Credentials;
import android.net.LocalSocket;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.server.LocalSocketHttpServerConnection;
import com.facebook.stetho.server.PeerAuthorizationException;
import java.io.IOException;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public abstract class SecureHttpRequestHandler
implements HttpRequestHandler {
    private static final Class<?> TAG = SecureHttpRequestHandler.class;
    private final Context mContext;

    public SecureHttpRequestHandler(Context context) {
        this.mContext = context;
    }

    @SuppressLint(value={"LogMethodNoExceptionInCatch"})
    public final void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            this.ensureSecureRequest(request, context);
            this.handleSecured(request, response, context);
        }
        catch (PeerAuthorizationException e) {
            LogUtil.e("Unauthorized request: " + e.getMessage());
            response.setStatusCode(403);
            response.setEntity((HttpEntity)new StringEntity(e.getMessage() + "\n", "UTF-8"));
        }
    }

    protected abstract void handleSecured(HttpRequest var1, HttpResponse var2, HttpContext var3) throws HttpException, IOException;

    private void ensureSecureRequest(HttpRequest request, HttpContext context) throws PeerAuthorizationException, IOException {
        HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
        if (!(conn instanceof LocalSocketHttpServerConnection)) {
            throw new PeerAuthorizationException("Unexpected connection class: " + conn.getClass().getName());
        }
        LocalSocketHttpServerConnection socketLikeConn = (LocalSocketHttpServerConnection)conn;
        LocalSocket socket = socketLikeConn.getSocket();
        SecureHttpRequestHandler.enforcePermission(this.mContext, socket);
    }

    private static void enforcePermission(Context context, LocalSocket peer) throws IOException, PeerAuthorizationException {
        String requiredPermission;
        int checkResult;
        Credentials credentials = peer.getPeerCredentials();
        int uid = credentials.getUid();
        int pid = credentials.getPid();
        if (LogUtil.isLoggable(2)) {
            LogUtil.v("Got request from uid=%d, pid=%d", uid, pid);
        }
        if ((checkResult = context.checkPermission(requiredPermission = "android.permission.DUMP", pid, uid)) != 0) {
            throw new PeerAuthorizationException("Peer pid=" + pid + ", uid=" + uid + " does not have " + requiredPermission);
        }
    }
}

