/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.server;

import android.net.LocalSocket;
import com.facebook.stetho.common.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.impl.AbstractHttpServerConnection;
import org.apache.http.impl.io.AbstractSessionInputBuffer;
import org.apache.http.impl.io.AbstractSessionOutputBuffer;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class LocalSocketHttpServerConnection
extends AbstractHttpServerConnection {
    private volatile LocalSocket mSocket;
    private volatile boolean mOpen;
    private volatile LocalSocketSessionInputBuffer mInputBuffer;

    public void bind(LocalSocket socket, HttpParams params) throws IOException {
        Util.throwIfNull(socket);
        Util.throwIfNull(params);
        this.mSocket = socket;
        int bufferSize = HttpConnectionParams.getSocketBufferSize((HttpParams)params);
        this.mInputBuffer = new LocalSocketSessionInputBuffer(socket, bufferSize, params);
        this.init((SessionInputBuffer)this.mInputBuffer, (SessionOutputBuffer)new LocalSocketSessionOutputBuffer(socket, bufferSize, params), params);
        this.mOpen = true;
    }

    public LocalSocket getSocket() {
        return this.mSocket;
    }

    public byte[] clearInputBuffer() {
        return this.mInputBuffer.clearCurrentBuffer();
    }

    protected void assertOpen() throws IllegalStateException {
        Util.throwIfNot(this.mOpen);
    }

    public boolean isOpen() {
        return this.mOpen;
    }

    public void setSocketTimeout(int timeout) {
        try {
            this.mSocket.setSoTimeout(timeout);
        }
        catch (IOException e) {
            Util.throwIfNot(this.mSocket.isClosed());
        }
    }

    public int getSocketTimeout() {
        try {
            return this.mSocket.getSoTimeout();
        }
        catch (IOException e) {
            Util.throwIfNot(this.mSocket.isClosed());
            return -1;
        }
    }

    public void shutdown() throws IOException {
        this.close(false);
    }

    public void close() throws IOException {
        this.close(true);
    }

    private void close(boolean doFlush) throws IOException {
        if (!this.mOpen) {
            return;
        }
        this.mOpen = false;
        if (doFlush) {
            this.doFlush();
        }
        this.mSocket.close();
    }

    private static class LocalSocketSessionOutputBuffer
    extends AbstractSessionOutputBuffer {
        public LocalSocketSessionOutputBuffer(LocalSocket socket, int bufferSize, HttpParams params) throws IOException {
            this.init(socket.getOutputStream(), bufferSize, params);
        }

        public void flush() throws IOException {
            this.flushBuffer();
        }
    }

    private static class LocalSocketSessionInputBuffer
    extends AbstractSessionInputBuffer {
        public LocalSocketSessionInputBuffer(LocalSocket socket, int bufferSize, HttpParams params) throws IOException {
            if (HttpConnectionParams.isStaleCheckingEnabled((HttpParams)params)) {
                throw new UnsupportedOperationException("Stale connection checking should not be used for local sockets");
            }
            this.init(socket.getInputStream(), bufferSize, params);
        }

        public byte[] clearCurrentBuffer() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                while (this.hasBufferedData()) {
                    int b = this.read();
                    Util.throwIfNot(b != -1, "Buffered data cannot EOF", new Object[0]);
                    buffer.write(b);
                }
                return buffer.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isDataAvailable(int timeout) throws IOException {
            throw new UnsupportedOperationException("CoreConnectionPNames.STALE_CONNECTION_CHECK appears to be true but that can't be?");
        }
    }
}

