/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.server;

import android.annotation.SuppressLint;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.ProcessUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.server.LocalSocketHttpServerConnection;
import com.facebook.stetho.server.RegistryInitializer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class LocalSocketHttpServer {
    private static final String WORKDER_THREAD_NAME_PREFIX = "StethoWorker";
    private static final int MAX_BIND_RETRIES = 2;
    private static final int TIME_BETWEEN_BIND_RETRIES_MS = 1000;
    private static final String SOCKET_NAME_PREFIX = "stetho_";
    private static final String SOCKET_NAME_SUFFIX = "_devtools_remote";
    private static final AtomicInteger sThreadId = new AtomicInteger();
    private final RegistryInitializer mRegistryInitializer;
    private final String mAddress;
    private Thread mListenerThread;
    private boolean mStopped;
    private LocalServerSocket mServerSocket;

    public LocalSocketHttpServer(RegistryInitializer registryInitializer) {
        this(registryInitializer, null);
    }

    public LocalSocketHttpServer(RegistryInitializer registryInitializer, String address) {
        this.mRegistryInitializer = Util.throwIfNull(registryInitializer);
        this.mAddress = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        LocalSocketHttpServer localSocketHttpServer = this;
        synchronized (localSocketHttpServer) {
            if (this.mStopped) {
                return;
            }
            this.mListenerThread = Thread.currentThread();
        }
        String address = this.mAddress != null ? this.mAddress : LocalSocketHttpServer.getDefaultAddress();
        this.listenOnAddress(address);
    }

    private void listenOnAddress(String address) throws IOException {
        this.mServerSocket = LocalSocketHttpServer.bindToSocket(address);
        LogUtil.i("Listening on @" + address);
        HttpParams params = null;
        HttpService service = null;
        while (!Thread.interrupted()) {
            LocalSocketHttpServerConnection connection = new LocalSocketHttpServerConnection();
            try {
                LocalSocket socket = this.mServerSocket.accept();
                if (params == null) {
                    params = this.createParams();
                }
                if (service == null) {
                    service = this.createService(params);
                }
                connection.bind(socket, params);
                WorkerThread t = new WorkerThread(service, (HttpServerConnection)connection);
                t.setDaemon(true);
                t.start();
            }
            catch (SocketException se) {
                if (Thread.interrupted()) continue;
                LogUtil.w(se, "I/O error");
            }
            catch (InterruptedIOException ex) {
                break;
            }
            catch (IOException e) {
                LogUtil.w(e, "I/O error initialising connection thread");
                break;
            }
        }
    }

    private static String getDefaultAddress() throws IOException {
        return SOCKET_NAME_PREFIX + ProcessUtil.getProcessName() + SOCKET_NAME_SUFFIX;
    }

    private HttpParams createParams() {
        return new BasicHttpParams().setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"Stetho").setParameter("http.protocol.version", (Object)"HTTP/1.1");
    }

    private HttpService createService(HttpParams params) {
        HttpRequestHandlerRegistry registry = this.mRegistryInitializer.getRegistry();
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        HttpService service = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
        service.setParams(params);
        service.setHandlerResolver((HttpRequestHandlerResolver)registry);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LocalSocketHttpServer localSocketHttpServer = this;
        synchronized (localSocketHttpServer) {
            this.mStopped = true;
            if (this.mListenerThread == null) {
                return;
            }
        }
        this.mListenerThread.interrupt();
        try {
            if (this.mServerSocket != null) {
                this.mServerSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nonnull
    private static LocalServerSocket bindToSocket(String address) throws IOException {
        int retries = 2;
        BindException firstException = null;
        while (true) {
            try {
                if (LogUtil.isLoggable(3)) {
                    LogUtil.d("Trying to bind to @" + address);
                }
                return new LocalServerSocket(address);
            }
            catch (BindException be) {
                LogUtil.w(be, "Binding error, sleep 1000 ms...");
                if (firstException == null) {
                    firstException = be;
                }
                Util.sleepUninterruptibly(1000L);
                if (retries-- > 0) continue;
                throw firstException;
            }
            break;
        }
    }

    private static class WorkerThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection conn;

        public WorkerThread(HttpService httpservice, HttpServerConnection conn) {
            super(LocalSocketHttpServer.WORKDER_THREAD_NAME_PREFIX + sThreadId.incrementAndGet());
            this.httpservice = httpservice;
            this.conn = conn;
        }

        @Override
        @SuppressLint(value={"LogMethodNoExceptionInCatch"})
        public void run() {
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                if (!Thread.interrupted() && this.conn.isOpen()) {
                    this.httpservice.handleRequest(this.conn, (HttpContext)context);
                }
            }
            catch (ConnectionClosedException ex) {
                LogUtil.w("Client closed connection: %s", new Object[]{ex});
            }
            catch (IOException ex) {
                LogUtil.w("I/O error: %s", ex);
            }
            catch (HttpException ex) {
                LogUtil.w("Unrecoverable HTTP protocol violation: %s", new Object[]{ex});
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

