/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.json;

import com.facebook.stetho.common.ExceptionUtil;
import com.facebook.stetho.json.annotation.JsonProperty;
import com.facebook.stetho.json.annotation.JsonValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectMapper {
    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        if (fromValue == null) {
            return null;
        }
        if (toValueType != Object.class && toValueType.isAssignableFrom(fromValue.getClass())) {
            return (T)fromValue;
        }
        try {
            if (fromValue instanceof JSONObject) {
                return this._convertFromJSONObject((JSONObject)fromValue, toValueType);
            }
            if (toValueType == JSONObject.class) {
                return (T)this._convertToJSONObject(fromValue);
            }
            throw new IllegalArgumentException("Expecting either fromValue or toValueType to be a JSONObject");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtil.propagate(e.getCause());
        }
    }

    private <T> T _convertFromJSONObject(JSONObject jsonObject, Class<T> type) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, JSONException {
        Constructor<T> constructor = type.getDeclaredConstructor(null);
        constructor.setAccessible(true);
        T instance = constructor.newInstance(new Object[0]);
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Object value = jsonObject.opt(field.getName());
            Object setValue = this.getValueForField(field, value);
            try {
                field.set(instance, this.getValueForField(field, value));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Class: " + type.getSimpleName() + " " + "Field: " + field.getName() + " type " + setValue.getClass().getName(), e);
            }
        }
        return instance;
    }

    private Object getValueForField(Field field, Object value) throws JSONException {
        try {
            if (value != null) {
                if (value == JSONObject.NULL) {
                    return null;
                }
                if (value.getClass() == field.getType()) {
                    return value;
                }
                if (value instanceof JSONObject) {
                    return this.convertValue(value, field.getType());
                }
                if (field.getType().isEnum()) {
                    return this.getEnumValue((String)value, field.getType().asSubclass(Enum.class));
                }
                if (value instanceof JSONArray) {
                    return this.convertArrayToList(field, (JSONArray)value);
                }
                if (value instanceof Number) {
                    Number numberValue = (Number)value;
                    Class<?> clazz = field.getType();
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return numberValue.intValue();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return numberValue.longValue();
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return numberValue.doubleValue();
                    }
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(numberValue.floatValue());
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return numberValue.byteValue();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return numberValue.shortValue();
                    }
                    throw new IllegalArgumentException("Not setup to handle class " + clazz.getName());
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to set value for field " + field.getName(), e);
        }
        return value;
    }

    private Enum getEnumValue(String value, Class<? extends Enum> clazz) {
        Method method = ObjectMapper.getJsonValueMethod(clazz);
        if (method != null) {
            return this.getEnumByMethod(value, clazz, method);
        }
        return Enum.valueOf(clazz, value);
    }

    private Enum getEnumByMethod(String value, Class<? extends Enum> clazz, Method method) {
        Enum[] enumValues = clazz.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            Enum enumValue = enumValues[i];
            try {
                Object o = method.invoke((Object)enumValue, new Object[0]);
                if (o == null || !o.toString().equals(value)) continue;
                return enumValue;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        throw new IllegalArgumentException("No enum constant " + clazz.getName() + "." + value);
    }

    private List<Object> convertArrayToList(Field field, JSONArray array) throws IllegalAccessException, JSONException {
        if (List.class.isAssignableFrom(field.getType())) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length != 1) {
                throw new IllegalArgumentException("Only able to handle a single type in a list " + field.getName());
            }
            Class arrayClass = (Class)types[0];
            ArrayList<Object> objectList = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                if (arrayClass.isEnum()) {
                    objectList.add(this.getEnumValue(array.getString(i), arrayClass));
                    continue;
                }
                if (ObjectMapper.canDirectlySerializeClass(arrayClass)) {
                    objectList.add(array.get(i));
                    continue;
                }
                JSONObject jsonObject = array.getJSONObject(i);
                if (jsonObject == null) {
                    objectList.add(null);
                    continue;
                }
                objectList.add(this.convertValue(jsonObject, arrayClass));
            }
            return objectList;
        }
        throw new IllegalArgumentException("only know how to deserialize List<?> on field " + field.getName());
    }

    private JSONObject _convertToJSONObject(Object fromValue) throws JSONException, InvocationTargetException, IllegalAccessException {
        JSONObject jsonObject = new JSONObject();
        Field[] fields = fromValue.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            JsonProperty property = fields[i].getAnnotation(JsonProperty.class);
            if (property == null) continue;
            Object value = fields[i].get(fromValue);
            Class<?> clazz = fields[i].getType();
            if (value != null) {
                clazz = value.getClass();
            }
            String name = fields[i].getName();
            if (property.required() && value == null) {
                value = JSONObject.NULL;
            } else if (value != JSONObject.NULL) {
                value = this.getJsonValue(value, clazz, fields[i]);
            }
            jsonObject.put(name, value);
        }
        return jsonObject;
    }

    private Object getJsonValue(Object value, Class<?> clazz, Field field) throws InvocationTargetException, IllegalAccessException {
        if (value == null) {
            return null;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.convertListToJsonArray(value);
        }
        Method m = ObjectMapper.getJsonValueMethod(clazz);
        if (m != null) {
            return m.invoke(value, new Object[0]);
        }
        if (!ObjectMapper.canDirectlySerializeClass(clazz)) {
            return this.convertValue(value, JSONObject.class);
        }
        return value;
    }

    private JSONArray convertListToJsonArray(Object value) throws InvocationTargetException, IllegalAccessException {
        JSONArray array = new JSONArray();
        List list = (List)value;
        for (Object obj : list) {
            array.put(obj != null ? this.getJsonValue(obj, obj.getClass(), null) : null);
        }
        return array;
    }

    @Nullable
    private static Method getJsonValueMethod(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JsonValue jsonValue = methods[i].getAnnotation(JsonValue.class);
            if (jsonValue == null) continue;
            return methods[i];
        }
        return null;
    }

    private static boolean canDirectlySerializeClass(Class clazz) {
        return ObjectMapper.isWrapperOrPrimitiveType(clazz) || clazz.equals(String.class);
    }

    private static boolean isWrapperOrPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(Boolean.class) || clazz.equals(Integer.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Double.class) || clazz.equals(Long.class) || clazz.equals(Float.class);
    }
}

