/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.screencast;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Base64OutputStream;
import android.view.View;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.elements.android.ActivityTracker;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.protocol.module.Page;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class ScreencastDispatcher {
    private static final long FRAME_DELAY = 200L;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private final BitmapFetchRunnable mBitmapFetchRunnable = new BitmapFetchRunnable();
    private final ActivityTracker mActivityTracker = ActivityTracker.get();
    private final EventDispatchRunnable mEventDispatchRunnable = new EventDispatchRunnable();
    private final RectF mTempSrc = new RectF();
    private final RectF mTempDst = new RectF();
    private boolean mIsRunning;
    private Handler mBackgroundHandler;
    private JsonRpcPeer mPeer;
    private HandlerThread mHandlerThread;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Page.StartScreencastRequest mRequest;
    private ByteArrayOutputStream mStream;
    private Page.ScreencastFrameEvent mEvent = new Page.ScreencastFrameEvent();
    private Page.ScreencastFrameEventMetadata mMetadata = new Page.ScreencastFrameEventMetadata();

    public void startScreencast(JsonRpcPeer peer, Page.StartScreencastRequest request) {
        LogUtil.d("Starting screencast");
        this.mRequest = request;
        this.mHandlerThread = new HandlerThread("Screencast Thread");
        this.mHandlerThread.start();
        this.mPeer = peer;
        this.mIsRunning = true;
        this.mStream = new ByteArrayOutputStream();
        this.mBackgroundHandler = new Handler(this.mHandlerThread.getLooper());
        this.mMainHandler.postDelayed((Runnable)this.mBitmapFetchRunnable, 200L);
    }

    public void stopScreencast() {
        LogUtil.d("Stopping screencast");
        this.mBackgroundHandler.post((Runnable)new CancellationRunnable());
    }

    private class CancellationRunnable
    implements Runnable {
        private CancellationRunnable() {
        }

        @Override
        public void run() {
            ScreencastDispatcher.this.mHandlerThread.interrupt();
            ScreencastDispatcher.this.mMainHandler.removeCallbacks((Runnable)ScreencastDispatcher.this.mBitmapFetchRunnable);
            ScreencastDispatcher.this.mBackgroundHandler.removeCallbacks((Runnable)ScreencastDispatcher.this.mEventDispatchRunnable);
            ScreencastDispatcher.this.mIsRunning = false;
            ScreencastDispatcher.this.mHandlerThread = null;
            ScreencastDispatcher.this.mBitmap = null;
            ScreencastDispatcher.this.mCanvas = null;
            ScreencastDispatcher.this.mStream = null;
        }
    }

    private class EventDispatchRunnable
    implements Runnable {
        private Runnable mEndAction;

        private EventDispatchRunnable() {
        }

        private EventDispatchRunnable withEndAction(Runnable endAction) {
            this.mEndAction = endAction;
            return this;
        }

        @Override
        public void run() {
            if (!ScreencastDispatcher.this.mIsRunning || ScreencastDispatcher.this.mBitmap == null) {
                return;
            }
            int width = ScreencastDispatcher.this.mBitmap.getWidth();
            int height = ScreencastDispatcher.this.mBitmap.getHeight();
            ScreencastDispatcher.this.mStream.reset();
            Base64OutputStream base64Stream = new Base64OutputStream((OutputStream)ScreencastDispatcher.this.mStream, 0);
            Bitmap.CompressFormat format = Bitmap.CompressFormat.valueOf((String)((ScreencastDispatcher)ScreencastDispatcher.this).mRequest.format.toUpperCase());
            ScreencastDispatcher.this.mBitmap.compress(format, ((ScreencastDispatcher)ScreencastDispatcher.this).mRequest.quality, (OutputStream)base64Stream);
            ((ScreencastDispatcher)ScreencastDispatcher.this).mEvent.data = ScreencastDispatcher.this.mStream.toString();
            ((ScreencastDispatcher)ScreencastDispatcher.this).mMetadata.pageScaleFactor = 1;
            ((ScreencastDispatcher)ScreencastDispatcher.this).mMetadata.deviceWidth = width;
            ((ScreencastDispatcher)ScreencastDispatcher.this).mMetadata.deviceHeight = height;
            ((ScreencastDispatcher)ScreencastDispatcher.this).mEvent.metadata = ScreencastDispatcher.this.mMetadata;
            ScreencastDispatcher.this.mPeer.invokeMethod("Page.screencastFrame", ScreencastDispatcher.this.mEvent, null);
            ScreencastDispatcher.this.mMainHandler.postDelayed(this.mEndAction, 200L);
        }
    }

    private class BitmapFetchRunnable
    implements Runnable {
        private BitmapFetchRunnable() {
        }

        @Override
        public void run() {
            this.updateScreenBitmap();
            ScreencastDispatcher.this.mBackgroundHandler.post((Runnable)ScreencastDispatcher.this.mEventDispatchRunnable.withEndAction(this));
        }

        private void updateScreenBitmap() {
            if (!ScreencastDispatcher.this.mIsRunning) {
                return;
            }
            Activity activity = ScreencastDispatcher.this.mActivityTracker.tryGetTopActivity();
            if (activity == null) {
                return;
            }
            View rootView = activity.getWindow().getDecorView();
            try {
                if (ScreencastDispatcher.this.mBitmap == null) {
                    int viewWidth = rootView.getWidth();
                    int viewHeight = rootView.getHeight();
                    float scale = Math.min((float)((ScreencastDispatcher)ScreencastDispatcher.this).mRequest.maxWidth / (float)viewWidth, (float)((ScreencastDispatcher)ScreencastDispatcher.this).mRequest.maxHeight / (float)viewHeight);
                    int destWidth = (int)((float)viewWidth * scale);
                    int destHeight = (int)((float)viewHeight * scale);
                    ScreencastDispatcher.this.mBitmap = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                    ScreencastDispatcher.this.mCanvas = new Canvas(ScreencastDispatcher.this.mBitmap);
                    Matrix matrix = new Matrix();
                    ScreencastDispatcher.this.mTempSrc.set(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
                    ScreencastDispatcher.this.mTempDst.set(0.0f, 0.0f, (float)destWidth, (float)destHeight);
                    matrix.setRectToRect(ScreencastDispatcher.this.mTempSrc, ScreencastDispatcher.this.mTempDst, Matrix.ScaleToFit.CENTER);
                    ScreencastDispatcher.this.mCanvas.setMatrix(matrix);
                }
                rootView.draw(ScreencastDispatcher.this.mCanvas);
            }
            catch (OutOfMemoryError e) {
                LogUtil.w("Out of memory trying to allocate screencast Bitmap.");
            }
        }
    }
}

