/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.runtime;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.console.RuntimeRepl;
import com.facebook.stetho.inspector.console.RuntimeReplFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RhinoDetectingRuntimeReplFactory
implements RuntimeReplFactory {
    private final Context mContext;
    private boolean mSearchedForRhinoJs;
    private RuntimeReplFactory mRhinoReplFactory;
    private RuntimeException mRhinoJsUnexpectedError;

    public RhinoDetectingRuntimeReplFactory(Context context) {
        this.mContext = context;
    }

    @Override
    public RuntimeRepl newInstance() {
        if (!this.mSearchedForRhinoJs) {
            this.mSearchedForRhinoJs = true;
            try {
                this.mRhinoReplFactory = RhinoDetectingRuntimeReplFactory.findRhinoReplFactory(this.mContext);
            }
            catch (RuntimeException e) {
                this.mRhinoJsUnexpectedError = e;
            }
        }
        if (this.mRhinoReplFactory != null) {
            return this.mRhinoReplFactory.newInstance();
        }
        return new RuntimeRepl(){

            @Override
            public Object evaluate(String expression) throws Exception {
                if (RhinoDetectingRuntimeReplFactory.this.mRhinoJsUnexpectedError != null) {
                    return "stetho-js-rhino threw: " + RhinoDetectingRuntimeReplFactory.this.mRhinoJsUnexpectedError.toString();
                }
                return "Not supported without stetho-js-rhino dependency";
            }
        };
    }

    @Nullable
    private static RuntimeReplFactory findRhinoReplFactory(Context context) throws RuntimeException {
        try {
            Class<?> jsRuntimeReplFactory = Class.forName("com.facebook.stetho.rhino.JsRuntimeReplFactoryBuilder");
            Method defaultFactoryMethod = jsRuntimeReplFactory.getDeclaredMethod("defaultFactory", Context.class);
            return (RuntimeReplFactory)defaultFactoryMethod.invoke(null, context);
        }
        catch (ClassNotFoundException e) {
            LogUtil.i("Error finding stetho-js-rhino, cannot enable console evaluation!");
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

