/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.protocol.module;

import android.content.Context;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.console.RuntimeRepl;
import com.facebook.stetho.inspector.console.RuntimeReplFactory;
import com.facebook.stetho.inspector.helper.ObjectIdMapper;
import com.facebook.stetho.inspector.jsonrpc.DisconnectReceiver;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcError;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.inspector.runtime.RhinoDetectingRuntimeReplFactory;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import com.facebook.stetho.json.annotation.JsonValue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class Runtime
implements ChromeDevtoolsDomain {
    private final ObjectMapper mObjectMapper = new ObjectMapper();
    private static final Map<JsonRpcPeer, Session> sSessions = Collections.synchronizedMap(new HashMap());
    private final RuntimeReplFactory mReplFactory;

    @Deprecated
    public Runtime() {
        this(new RuntimeReplFactory(){

            @Override
            public RuntimeRepl newInstance() {
                return new RuntimeRepl(){

                    @Override
                    public Object evaluate(String expression) throws Throwable {
                        return "Not supported with legacy Runtime module";
                    }
                };
            }
        });
    }

    public Runtime(Context context) {
        this(new RhinoDetectingRuntimeReplFactory(context));
    }

    public Runtime(RuntimeReplFactory replFactory) {
        this.mReplFactory = replFactory;
    }

    public static int mapObject(JsonRpcPeer peer, Object object) {
        return Runtime.getSession(peer).getObjects().putObject(object);
    }

    @Nonnull
    private static synchronized Session getSession(final JsonRpcPeer peer) {
        Session session = sSessions.get(peer);
        if (session == null) {
            session = new Session();
            sSessions.put(peer, session);
            peer.registerDisconnectReceiver(new DisconnectReceiver(){

                @Override
                public void onDisconnect() {
                    sSessions.remove(peer);
                }
            });
        }
        return session;
    }

    @ChromeDevtoolsMethod
    public void releaseObject(JsonRpcPeer peer, JSONObject params) throws JSONException {
        String objectId = params.getString("objectId");
        Runtime.getSession(peer).getObjects().removeObjectById(Integer.parseInt(objectId));
    }

    @ChromeDevtoolsMethod
    public void releaseObjectGroup(JsonRpcPeer peer, JSONObject params) {
        LogUtil.w("Ignoring request to releaseObjectGroup: " + params);
    }

    @ChromeDevtoolsMethod
    public CallFunctionOnResponse callFunctionOn(JsonRpcPeer peer, JSONObject params) throws JsonRpcException {
        CallFunctionOnRequest args = this.mObjectMapper.convertValue(params, CallFunctionOnRequest.class);
        Session session = Runtime.getSession(peer);
        Object object = session.getObjectOrThrow(args.objectId);
        if (!args.functionDeclaration.startsWith("function protoList(")) {
            throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.INTERNAL_ERROR, "Expected protoList, got: " + args.functionDeclaration, null));
        }
        ObjectProtoContainer objectContainer = new ObjectProtoContainer(object);
        RemoteObject result = new RemoteObject();
        result.type = ObjectType.OBJECT;
        result.subtype = ObjectSubType.NODE;
        result.className = object.getClass().getName();
        result.description = Runtime.getPropertyClassName(object);
        result.objectId = String.valueOf(session.getObjects().putObject(objectContainer));
        CallFunctionOnResponse response = new CallFunctionOnResponse();
        response.result = result;
        response.wasThrown = false;
        return response;
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult evaluate(JsonRpcPeer peer, JSONObject params) {
        return Runtime.getSession(peer).evaluate(this.mReplFactory, params);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getProperties(JsonRpcPeer peer, JSONObject params) throws JsonRpcException {
        return Runtime.getSession(peer).getProperties(params);
    }

    private static String getPropertyClassName(Object o) {
        String name = o.getClass().getSimpleName();
        if (name == null || name.length() == 0) {
            name = o.getClass().getName();
        }
        return name;
    }

    public static enum ObjectSubType {
        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error");

        private final String mProtocolValue;

        private ObjectSubType(String protocolValue) {
            this.mProtocolValue = protocolValue;
        }

        @JsonValue
        public String getProtocolValue() {
            return this.mProtocolValue;
        }
    }

    public static enum ObjectType {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol");

        private final String mProtocolValue;

        private ObjectType(String protocolValue) {
            this.mProtocolValue = protocolValue;
        }

        @JsonValue
        public String getProtocolValue() {
            return this.mProtocolValue;
        }
    }

    private static class PropertyDescriptor {
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(required=true)
        public RemoteObject value;
        @JsonProperty(required=true)
        public final boolean isOwn = true;
        @JsonProperty(required=true)
        public final boolean configurable = false;
        @JsonProperty(required=true)
        public final boolean enumerable = true;
        @JsonProperty(required=true)
        public final boolean writable = false;

        private PropertyDescriptor() {
        }
    }

    public static class RemoteObject {
        @JsonProperty(required=true)
        public ObjectType type;
        @JsonProperty
        public ObjectSubType subtype;
        @JsonProperty
        public Object value;
        @JsonProperty
        public String className;
        @JsonProperty
        public String description;
        @JsonProperty
        public String objectId;
    }

    private static class ExceptionDetails {
        @JsonProperty(required=true)
        public String text;

        private ExceptionDetails() {
        }
    }

    private static class EvaluateResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public RemoteObject result;
        @JsonProperty(required=true)
        public boolean wasThrown;
        @JsonProperty
        public ExceptionDetails exceptionDetails;

        private EvaluateResponse() {
        }
    }

    private static class EvaluateRequest
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public String objectGroup;
        @JsonProperty(required=true)
        public String expression;

        private EvaluateRequest() {
        }
    }

    private static class GetPropertiesResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public List<PropertyDescriptor> result;

        private GetPropertiesResponse() {
        }
    }

    private static class GetPropertiesRequest
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public boolean ownProperties;
        @JsonProperty(required=true)
        public String objectId;

        private GetPropertiesRequest() {
        }
    }

    private static class CallArgument {
        @JsonProperty(required=false)
        public Object value;
        @JsonProperty(required=false)
        public String objectId;
        @JsonProperty(required=false)
        public ObjectType type;

        private CallArgument() {
        }
    }

    private static class CallFunctionOnResponse
    implements JsonRpcResult {
        @JsonProperty
        public RemoteObject result;
        @JsonProperty(required=false)
        public Boolean wasThrown;

        private CallFunctionOnResponse() {
        }
    }

    private static class CallFunctionOnRequest {
        @JsonProperty
        public String objectId;
        @JsonProperty
        public String functionDeclaration;
        @JsonProperty
        public List<CallArgument> arguments;
        @JsonProperty(required=false)
        public Boolean doNotPauseOnExceptionsAndMuteConsole;
        @JsonProperty(required=false)
        public Boolean returnByValue;
        @JsonProperty(required=false)
        public Boolean generatePreview;

        private CallFunctionOnRequest() {
        }
    }

    private static class Session {
        private final ObjectIdMapper mObjects = new ObjectIdMapper();
        private final ObjectMapper mObjectMapper = new ObjectMapper();
        @Nullable
        private RuntimeRepl mRepl;

        private Session() {
        }

        public ObjectIdMapper getObjects() {
            return this.mObjects;
        }

        public Object getObjectOrThrow(String objectId) throws JsonRpcException {
            Object object = this.getObjects().getObjectForId(Integer.parseInt(objectId));
            if (object == null) {
                throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.INVALID_REQUEST, "No object found for " + objectId, null));
            }
            return object;
        }

        public RemoteObject objectForRemote(Object value) {
            RemoteObject result = new RemoteObject();
            if (value == null) {
                result.type = ObjectType.OBJECT;
                result.subtype = ObjectSubType.NULL;
                result.value = JSONObject.NULL;
            } else if (value instanceof Boolean) {
                result.type = ObjectType.BOOLEAN;
                result.value = value;
            } else if (value instanceof Number) {
                result.type = ObjectType.NUMBER;
                result.value = value;
            } else if (value instanceof Character) {
                result.type = ObjectType.NUMBER;
                result.value = (int)((Character)value).charValue();
            } else if (value instanceof String) {
                result.type = ObjectType.STRING;
                result.value = String.valueOf(value);
            } else {
                result.type = ObjectType.OBJECT;
                result.className = "What??";
                result.objectId = String.valueOf(this.mObjects.putObject(value));
                result.description = value.getClass().isArray() ? "array" : (value instanceof List ? "List" : (value instanceof Set ? "Set" : (value instanceof Map ? "Map" : Runtime.getPropertyClassName(value))));
            }
            return result;
        }

        public EvaluateResponse evaluate(RuntimeReplFactory replFactory, JSONObject params) {
            EvaluateRequest request = this.mObjectMapper.convertValue(params, EvaluateRequest.class);
            try {
                if (!request.objectGroup.equals("console")) {
                    return this.buildExceptionResponse("Not supported by FAB");
                }
                RuntimeRepl repl = this.getRepl(replFactory);
                Object result = repl.evaluate(request.expression);
                return this.buildNormalResponse(result);
            }
            catch (Throwable t) {
                return this.buildExceptionResponse(t);
            }
        }

        @Nonnull
        private synchronized RuntimeRepl getRepl(RuntimeReplFactory replFactory) {
            if (this.mRepl == null) {
                this.mRepl = replFactory.newInstance();
            }
            return this.mRepl;
        }

        private EvaluateResponse buildNormalResponse(Object retval) {
            EvaluateResponse response = new EvaluateResponse();
            response.wasThrown = false;
            response.result = this.objectForRemote(retval);
            return response;
        }

        private EvaluateResponse buildExceptionResponse(Object retval) {
            EvaluateResponse response = new EvaluateResponse();
            response.wasThrown = true;
            response.result = this.objectForRemote(retval);
            response.exceptionDetails = new ExceptionDetails();
            response.exceptionDetails.text = retval.toString();
            return response;
        }

        public GetPropertiesResponse getProperties(JSONObject params) throws JsonRpcException {
            GetPropertiesRequest request = this.mObjectMapper.convertValue(params, GetPropertiesRequest.class);
            if (!request.ownProperties) {
                GetPropertiesResponse response = new GetPropertiesResponse();
                response.result = new ArrayList<PropertyDescriptor>();
                return response;
            }
            List<?> object = this.getObjectOrThrow(request.objectId);
            if (object.getClass().isArray()) {
                object = this.arrayToList(object);
            }
            if (object instanceof ObjectProtoContainer) {
                return this.getPropertiesForProtoContainer((ObjectProtoContainer)((Object)object));
            }
            if (object instanceof List) {
                return this.getPropertiesForIterable(object, true);
            }
            if (object instanceof Set) {
                return this.getPropertiesForIterable((Set)((Object)object), false);
            }
            if (object instanceof Map) {
                return this.getPropertiesForMap(object);
            }
            return this.getPropertiesForObject(object);
        }

        private List<?> arrayToList(Object object) {
            Class<?> type = object.getClass();
            if (!type.isArray()) {
                throw new IllegalArgumentException("Argument must be an array.  Was " + type);
            }
            Class<?> component = type.getComponentType();
            if (!component.isPrimitive()) {
                return Arrays.asList((Object[])object);
            }
            int length = Array.getLength(object);
            ArrayList<Object> ret = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                ret.add(Array.get(object, i));
            }
            return ret;
        }

        private GetPropertiesResponse getPropertiesForProtoContainer(ObjectProtoContainer proto) {
            Object target = proto.object;
            RemoteObject protoRemote = new RemoteObject();
            protoRemote.type = ObjectType.OBJECT;
            protoRemote.subtype = ObjectSubType.NODE;
            protoRemote.className = target.getClass().getName();
            protoRemote.description = Runtime.getPropertyClassName(target);
            protoRemote.objectId = String.valueOf(this.mObjects.putObject(target));
            PropertyDescriptor descriptor = new PropertyDescriptor();
            descriptor.name = "1";
            descriptor.value = protoRemote;
            GetPropertiesResponse response = new GetPropertiesResponse();
            response.result = new ArrayList<PropertyDescriptor>(1);
            response.result.add(descriptor);
            return response;
        }

        private GetPropertiesResponse getPropertiesForIterable(Iterable<?> object, boolean enumerate) {
            GetPropertiesResponse response = new GetPropertiesResponse();
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
            int index = 0;
            for (Object value : object) {
                PropertyDescriptor property = new PropertyDescriptor();
                property.name = enumerate ? String.valueOf(index++) : null;
                property.value = this.objectForRemote(value);
                properties.add(property);
            }
            response.result = properties;
            return response;
        }

        private GetPropertiesResponse getPropertiesForMap(Object object) {
            GetPropertiesResponse response = new GetPropertiesResponse();
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                PropertyDescriptor property = new PropertyDescriptor();
                property.name = String.valueOf(entry.getKey());
                property.value = this.objectForRemote(entry.getValue());
                properties.add(property);
            }
            response.result = properties;
            return response;
        }

        private GetPropertiesResponse getPropertiesForObject(Object object) {
            GetPropertiesResponse response = new GetPropertiesResponse();
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
            for (Class<?> declaringClass = object.getClass(); declaringClass != null; declaringClass = declaringClass.getSuperclass()) {
                ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaringClass.getDeclaredFields()));
                Collections.reverse(fields);
                String prefix = declaringClass == object.getClass() ? "" : declaringClass.getSimpleName() + ".";
                for (Field field : fields) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    try {
                        Object fieldValue = field.get(object);
                        PropertyDescriptor property = new PropertyDescriptor();
                        property.name = prefix + field.getName();
                        property.value = this.objectForRemote(fieldValue);
                        properties.add(property);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            Collections.reverse(properties);
            response.result = properties;
            return response;
        }
    }

    private static class ObjectProtoContainer {
        public final Object object;

        public ObjectProtoContainer(Object object) {
            this.object = object;
        }
    }
}

