/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.protocol.module;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.database.DatabaseFilesProvider;
import com.facebook.stetho.inspector.database.DatabasePeerManager;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcError;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

@TargetApi(value=11)
public class Database
implements ChromeDevtoolsDomain {
    private static final int MAX_EXECUTE_RESULTS = 250;
    private final DatabasePeerManager mDatabasePeerManager;
    private final ObjectMapper mObjectMapper;

    @Deprecated
    public Database(Context context) {
        this.mDatabasePeerManager = new DatabasePeerManager(context);
        this.mObjectMapper = new ObjectMapper();
    }

    public Database(Context context, DatabaseFilesProvider databaseFilesProvider) {
        this.mDatabasePeerManager = new DatabasePeerManager(context, databaseFilesProvider);
        this.mObjectMapper = new ObjectMapper();
    }

    @ChromeDevtoolsMethod
    public void enable(JsonRpcPeer peer, JSONObject params) {
        this.mDatabasePeerManager.addPeer(peer);
    }

    @ChromeDevtoolsMethod
    public void disable(JsonRpcPeer peer, JSONObject params) {
        this.mDatabasePeerManager.removePeer(peer);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getDatabaseTableNames(JsonRpcPeer peer, JSONObject params) throws JsonRpcException {
        GetDatabaseTableNamesRequest request = this.mObjectMapper.convertValue(params, GetDatabaseTableNamesRequest.class);
        try {
            GetDatabaseTableNamesResponse response = new GetDatabaseTableNamesResponse();
            response.tableNames = this.mDatabasePeerManager.getDatabaseTableNames(request.databaseId);
            return response;
        }
        catch (SQLiteException e) {
            throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.INVALID_REQUEST, e.toString(), null));
        }
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult executeSQL(JsonRpcPeer peer, JSONObject params) {
        ExecuteSQLRequest request = this.mObjectMapper.convertValue(params, ExecuteSQLRequest.class);
        try {
            return this.mDatabasePeerManager.executeSQL(request.databaseId, request.query, new DatabasePeerManager.ExecuteResultHandler<ExecuteSQLResponse>(){

                @Override
                public ExecuteSQLResponse handleRawQuery() throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Arrays.asList("success");
                    response.values = Arrays.asList("true");
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleSelect(Cursor result) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Arrays.asList(result.getColumnNames());
                    response.values = Database.this.flattenRows(result, 250);
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleInsert(long insertedId) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Arrays.asList("ID of last inserted row");
                    response.values = Arrays.asList(insertedId);
                    return response;
                }

                @Override
                public ExecuteSQLResponse handleUpdateDelete(int count) throws SQLiteException {
                    ExecuteSQLResponse response = new ExecuteSQLResponse();
                    response.columnNames = Arrays.asList("Modified rows");
                    response.values = Arrays.asList(count);
                    return response;
                }
            });
        }
        catch (SQLiteException e) {
            Error error = new Error();
            error.code = 0;
            error.message = e.getMessage();
            ExecuteSQLResponse response = new ExecuteSQLResponse();
            response.sqlError = error;
            return response;
        }
    }

    private List<Object> flattenRows(Cursor cursor, int limit) {
        Util.throwIfNot(limit >= 0);
        ArrayList<Object> flatList = new ArrayList<Object>();
        int numColumns = cursor.getColumnCount();
        for (int row = 0; row < limit && cursor.moveToNext(); ++row) {
            block7: for (int column = 0; column < numColumns; ++column) {
                switch (cursor.getType(column)) {
                    case 0: {
                        flatList.add(null);
                        continue block7;
                    }
                    case 1: {
                        flatList.add(cursor.getLong(column));
                        continue block7;
                    }
                    case 2: {
                        flatList.add(cursor.getDouble(column));
                        continue block7;
                    }
                    case 4: {
                        flatList.add(cursor.getBlob(column));
                        continue block7;
                    }
                    default: {
                        flatList.add(cursor.getString(column));
                    }
                }
            }
        }
        if (!cursor.isAfterLast()) {
            for (int column = 0; column < numColumns; ++column) {
                flatList.add("{truncated}");
            }
        }
        return flatList;
    }

    public static class Error {
        @JsonProperty(required=true)
        public String message;
        @JsonProperty(required=true)
        public int code;
    }

    public static class DatabaseObject {
        @JsonProperty(required=true)
        public String id;
        @JsonProperty(required=true)
        public String domain;
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(required=true)
        public String version;
    }

    public static class AddDatabaseEvent {
        @JsonProperty(required=true)
        public DatabaseObject database;
    }

    private static class ExecuteSQLResponse
    implements JsonRpcResult {
        @JsonProperty
        public List<String> columnNames;
        @JsonProperty
        public List<Object> values;
        @JsonProperty
        public Error sqlError;

        private ExecuteSQLResponse() {
        }
    }

    private static class ExecuteSQLRequest {
        @JsonProperty(required=true)
        public String databaseId;
        @JsonProperty(required=true)
        public String query;

        private ExecuteSQLRequest() {
        }
    }

    private static class GetDatabaseTableNamesResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public List<String> tableNames;

        private GetDatabaseTableNamesResponse() {
        }
    }

    private static class GetDatabaseTableNamesRequest {
        @JsonProperty(required=true)
        public String databaseId;

        private GetDatabaseTableNamesRequest() {
        }
    }
}

