/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.protocol.module;

import android.graphics.Color;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.ArrayListAccumulator;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.UncheckedCallable;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.elements.Document;
import com.facebook.stetho.inspector.elements.DocumentView;
import com.facebook.stetho.inspector.elements.ElementInfo;
import com.facebook.stetho.inspector.elements.NodeDescriptor;
import com.facebook.stetho.inspector.elements.NodeType;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeersRegisteredListener;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcError;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.inspector.protocol.module.Runtime;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class DOM
implements ChromeDevtoolsDomain {
    private final ObjectMapper mObjectMapper = new ObjectMapper();
    private final Document mDocument;
    private final Map<String, List<Integer>> mSearchResults;
    private final AtomicInteger mResultCounter;
    private final ChromePeerManager mPeerManager;
    private final DocumentUpdateListener mListener;
    private ChildNodeRemovedEvent mCachedChildNodeRemovedEvent;
    private ChildNodeInsertedEvent mCachedChildNodeInsertedEvent;

    public DOM(Document document) {
        this.mDocument = Util.throwIfNull(document);
        this.mSearchResults = Collections.synchronizedMap(new HashMap());
        this.mResultCounter = new AtomicInteger(0);
        this.mPeerManager = new ChromePeerManager();
        this.mPeerManager.setListener(new PeerManagerListener());
        this.mListener = new DocumentUpdateListener();
    }

    @ChromeDevtoolsMethod
    public void enable(JsonRpcPeer peer, JSONObject params) {
        this.mPeerManager.addPeer(peer);
    }

    @ChromeDevtoolsMethod
    public void disable(JsonRpcPeer peer, JSONObject params) {
        this.mPeerManager.removePeer(peer);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getDocument(JsonRpcPeer peer, JSONObject params) {
        GetDocumentResponse result = new GetDocumentResponse();
        result.root = this.mDocument.postAndWait(new UncheckedCallable<Node>(){

            @Override
            public Node call() {
                Object element = DOM.this.mDocument.getRootElement();
                return DOM.this.createNodeForElement(element, DOM.this.mDocument.getDocumentView());
            }
        });
        return result;
    }

    @ChromeDevtoolsMethod
    public void highlightNode(JsonRpcPeer peer, JSONObject params) {
        final HighlightNodeRequest request = this.mObjectMapper.convertValue(params, HighlightNodeRequest.class);
        if (request.nodeId == null) {
            LogUtil.w("DOM.highlightNode was not given a nodeId; JS objectId is not supported");
            return;
        }
        final RGBAColor contentColor = request.highlightConfig.contentColor;
        if (contentColor == null) {
            LogUtil.w("DOM.highlightNode was not given a color to highlight with");
            return;
        }
        this.mDocument.postAndWait(new Runnable(){

            @Override
            public void run() {
                Object element = DOM.this.mDocument.getElementForNodeId(request.nodeId);
                if (element != null) {
                    DOM.this.mDocument.highlightElement(element, contentColor.getColor());
                }
            }
        });
    }

    @ChromeDevtoolsMethod
    public void hideHighlight(JsonRpcPeer peer, JSONObject params) {
        this.mDocument.postAndWait(new Runnable(){

            @Override
            public void run() {
                DOM.this.mDocument.hideHighlight();
            }
        });
    }

    @ChromeDevtoolsMethod
    public ResolveNodeResponse resolveNode(JsonRpcPeer peer, JSONObject params) throws JsonRpcException {
        final ResolveNodeRequest request = this.mObjectMapper.convertValue(params, ResolveNodeRequest.class);
        Object element = this.mDocument.postAndWait(new UncheckedCallable<Object>(){

            @Override
            public Object call() {
                return DOM.this.mDocument.getElementForNodeId(request.nodeId);
            }
        });
        if (element == null) {
            throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.INVALID_PARAMS, "No known nodeId=" + request.nodeId, null));
        }
        int mappedObjectId = Runtime.mapObject(peer, element);
        Runtime.RemoteObject remoteObject = new Runtime.RemoteObject();
        remoteObject.type = Runtime.ObjectType.OBJECT;
        remoteObject.subtype = Runtime.ObjectSubType.NODE;
        remoteObject.className = element.getClass().getName();
        remoteObject.value = null;
        remoteObject.description = null;
        remoteObject.objectId = String.valueOf(mappedObjectId);
        ResolveNodeResponse response = new ResolveNodeResponse();
        response.object = remoteObject;
        return response;
    }

    @ChromeDevtoolsMethod
    public void setAttributesAsText(JsonRpcPeer peer, JSONObject params) {
        final SetAttributesAsTextRequest request = this.mObjectMapper.convertValue(params, SetAttributesAsTextRequest.class);
        this.mDocument.postAndWait(new Runnable(){

            @Override
            public void run() {
                Object element = DOM.this.mDocument.getElementForNodeId(request.nodeId);
                if (element != null) {
                    DOM.this.mDocument.setAttributesAsText(element, request.text);
                }
            }
        });
    }

    @ChromeDevtoolsMethod
    public void setInspectModeEnabled(JsonRpcPeer peer, JSONObject params) {
        final SetInspectModeEnabledRequest request = this.mObjectMapper.convertValue(params, SetInspectModeEnabledRequest.class);
        this.mDocument.postAndWait(new Runnable(){

            @Override
            public void run() {
                DOM.this.mDocument.setInspectModeEnabled(request.enabled);
            }
        });
    }

    @ChromeDevtoolsMethod
    public PerformSearchResponse performSearch(JsonRpcPeer peer, JSONObject params) {
        final PerformSearchRequest request = this.mObjectMapper.convertValue(params, PerformSearchRequest.class);
        final ArrayListAccumulator resultNodeIds = new ArrayListAccumulator();
        this.mDocument.postAndWait(new Runnable(){

            @Override
            public void run() {
                DOM.this.mDocument.findMatchingElements(request.query, resultNodeIds);
            }
        });
        String searchId = String.valueOf(this.mResultCounter.getAndIncrement());
        this.mSearchResults.put(searchId, resultNodeIds);
        PerformSearchResponse response = new PerformSearchResponse();
        response.searchId = searchId;
        response.resultCount = resultNodeIds.size();
        return response;
    }

    @ChromeDevtoolsMethod
    public GetSearchResultsResponse getSearchResults(JsonRpcPeer peer, JSONObject params) {
        GetSearchResultsRequest request = this.mObjectMapper.convertValue(params, GetSearchResultsRequest.class);
        if (request.searchId == null) {
            LogUtil.w("searchId may not be null");
            return null;
        }
        List<Integer> results = this.mSearchResults.get(request.searchId);
        if (results == null) {
            LogUtil.w("\"" + request.searchId + "\" is not a valid reference to a search result");
            return null;
        }
        List<Integer> resultsRange = results.subList(request.fromIndex, request.toIndex);
        GetSearchResultsResponse response = new GetSearchResultsResponse();
        response.nodeIds = resultsRange;
        return response;
    }

    @ChromeDevtoolsMethod
    public void discardSearchResults(JsonRpcPeer peer, JSONObject params) {
        DiscardSearchResultsRequest request = this.mObjectMapper.convertValue(params, DiscardSearchResultsRequest.class);
        if (request.searchId != null) {
            this.mSearchResults.remove(request.searchId);
        }
    }

    private Node createNodeForElement(Object element, DocumentView view) {
        NodeDescriptor descriptor = this.mDocument.getNodeDescriptor(element);
        Node node = new Node();
        node.nodeId = this.mDocument.getNodeIdForElement(element);
        node.nodeType = descriptor.getNodeType(element);
        node.nodeName = descriptor.getNodeName(element);
        node.localName = descriptor.getLocalName(element);
        node.nodeValue = descriptor.getNodeValue(element);
        Document.AttributeListAccumulator accumulator = new Document.AttributeListAccumulator();
        descriptor.getAttributes(element, accumulator);
        node.attributes = accumulator;
        ElementInfo elementInfo = view.getElementInfo(element);
        ArrayList<Node> childrenNodes = elementInfo.children.size() == 0 ? Collections.emptyList() : new ArrayList<Node>(elementInfo.children.size());
        int N = elementInfo.children.size();
        for (int i = 0; i < N; ++i) {
            Object childElement = elementInfo.children.get(i);
            Node childNode = this.createNodeForElement(childElement, view);
            childrenNodes.add(childNode);
        }
        node.children = childrenNodes;
        node.childNodeCount = childrenNodes.size();
        return node;
    }

    private ChildNodeInsertedEvent acquireChildNodeInsertedEvent() {
        ChildNodeInsertedEvent childNodeInsertedEvent = this.mCachedChildNodeInsertedEvent;
        if (childNodeInsertedEvent == null) {
            childNodeInsertedEvent = new ChildNodeInsertedEvent();
        }
        this.mCachedChildNodeInsertedEvent = null;
        return childNodeInsertedEvent;
    }

    private void releaseChildNodeInsertedEvent(ChildNodeInsertedEvent childNodeInsertedEvent) {
        childNodeInsertedEvent.parentNodeId = -1;
        childNodeInsertedEvent.previousNodeId = -1;
        childNodeInsertedEvent.node = null;
        if (this.mCachedChildNodeInsertedEvent == null) {
            this.mCachedChildNodeInsertedEvent = childNodeInsertedEvent;
        }
    }

    private ChildNodeRemovedEvent acquireChildNodeRemovedEvent() {
        ChildNodeRemovedEvent childNodeRemovedEvent = this.mCachedChildNodeRemovedEvent;
        if (childNodeRemovedEvent == null) {
            childNodeRemovedEvent = new ChildNodeRemovedEvent();
        }
        this.mCachedChildNodeRemovedEvent = null;
        return childNodeRemovedEvent;
    }

    private void releaseChildNodeRemovedEvent(ChildNodeRemovedEvent childNodeRemovedEvent) {
        childNodeRemovedEvent.parentNodeId = -1;
        childNodeRemovedEvent.nodeId = -1;
        if (this.mCachedChildNodeRemovedEvent == null) {
            this.mCachedChildNodeRemovedEvent = childNodeRemovedEvent;
        }
    }

    private static class DiscardSearchResultsRequest {
        @JsonProperty(required=true)
        public String searchId;

        private DiscardSearchResultsRequest() {
        }
    }

    private static class GetSearchResultsResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public List<Integer> nodeIds;

        private GetSearchResultsResponse() {
        }
    }

    private static class GetSearchResultsRequest {
        @JsonProperty(required=true)
        public String searchId;
        @JsonProperty(required=true)
        public int fromIndex;
        @JsonProperty(required=true)
        public int toIndex;

        private GetSearchResultsRequest() {
        }
    }

    private static class PerformSearchResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public String searchId;
        @JsonProperty(required=true)
        public int resultCount;

        private PerformSearchResponse() {
        }
    }

    private static class PerformSearchRequest {
        @JsonProperty(required=true)
        public String query;
        @JsonProperty
        public Boolean includeUserAgentShadowDOM;

        private PerformSearchRequest() {
        }
    }

    private static class ResolveNodeResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public Runtime.RemoteObject object;

        private ResolveNodeResponse() {
        }
    }

    private static class SetAttributesAsTextRequest {
        @JsonProperty(required=true)
        public int nodeId;
        @JsonProperty(required=true)
        public String text;

        private SetAttributesAsTextRequest() {
        }
    }

    private static class ResolveNodeRequest {
        @JsonProperty(required=true)
        public int nodeId;
        @JsonProperty
        public String objectGroup;

        private ResolveNodeRequest() {
        }
    }

    private static class RGBAColor {
        @JsonProperty(required=true)
        public int r;
        @JsonProperty(required=true)
        public int g;
        @JsonProperty(required=true)
        public int b;
        @JsonProperty
        public Double a;

        private RGBAColor() {
        }

        public int getColor() {
            long aLong;
            int alpha = this.a == null ? -1 : (byte)((aLong = Math.round(this.a * 255.0)) < 0L ? 0 : (byte)(aLong >= 255L ? -1 : (byte)aLong));
            return Color.argb((int)alpha, (int)this.r, (int)this.g, (int)this.b);
        }
    }

    private static class SetInspectModeEnabledRequest {
        @JsonProperty(required=true)
        public boolean enabled;
        @JsonProperty
        public Boolean inspectShadowDOM;
        @JsonProperty
        public HighlightConfig highlightConfig;

        private SetInspectModeEnabledRequest() {
        }
    }

    private static class InspectNodeRequestedEvent {
        @JsonProperty
        public int nodeId;

        private InspectNodeRequestedEvent() {
        }
    }

    private static class HighlightConfig {
        @JsonProperty
        public RGBAColor contentColor;

        private HighlightConfig() {
        }
    }

    private static class HighlightNodeRequest {
        @JsonProperty(required=true)
        public HighlightConfig highlightConfig;
        @JsonProperty
        public Integer nodeId;
        @JsonProperty
        public String objectId;

        private HighlightNodeRequest() {
        }
    }

    private static class ChildNodeRemovedEvent {
        @JsonProperty(required=true)
        public int parentNodeId;
        @JsonProperty(required=true)
        public int nodeId;

        private ChildNodeRemovedEvent() {
        }
    }

    private static class ChildNodeInsertedEvent {
        @JsonProperty(required=true)
        public int parentNodeId;
        @JsonProperty(required=true)
        public int previousNodeId;
        @JsonProperty(required=true)
        public Node node;

        private ChildNodeInsertedEvent() {
        }
    }

    private static class AttributeRemovedEvent {
        @JsonProperty(required=true)
        public int nodeId;
        @JsonProperty(required=true)
        public String name;

        private AttributeRemovedEvent() {
        }
    }

    private static class AttributeModifiedEvent {
        @JsonProperty(required=true)
        public int nodeId;
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(required=true)
        public String value;

        private AttributeModifiedEvent() {
        }
    }

    private static class Node
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public int nodeId;
        @JsonProperty(required=true)
        public NodeType nodeType;
        @JsonProperty(required=true)
        public String nodeName;
        @JsonProperty(required=true)
        public String localName;
        @JsonProperty(required=true)
        public String nodeValue;
        @JsonProperty
        public Integer childNodeCount;
        @JsonProperty
        public List<Node> children;
        @JsonProperty
        public List<String> attributes;

        private Node() {
        }
    }

    private static class GetDocumentResponse
    implements JsonRpcResult {
        @JsonProperty(required=true)
        public Node root;

        private GetDocumentResponse() {
        }
    }

    private final class PeerManagerListener
    extends PeersRegisteredListener {
        private PeerManagerListener() {
        }

        @Override
        protected synchronized void onFirstPeerRegistered() {
            DOM.this.mDocument.addRef();
            DOM.this.mDocument.addUpdateListener(DOM.this.mListener);
        }

        @Override
        protected synchronized void onLastPeerUnregistered() {
            DOM.this.mSearchResults.clear();
            DOM.this.mDocument.removeUpdateListener(DOM.this.mListener);
            DOM.this.mDocument.release();
        }
    }

    private final class DocumentUpdateListener
    implements Document.UpdateListener {
        private DocumentUpdateListener() {
        }

        @Override
        public void onAttributeModified(Object element, String name, String value) {
            AttributeModifiedEvent message = new AttributeModifiedEvent();
            message.nodeId = DOM.this.mDocument.getNodeIdForElement(element);
            message.name = name;
            message.value = value;
            DOM.this.mPeerManager.sendNotificationToPeers("DOM.onAttributeModified", message);
        }

        @Override
        public void onAttributeRemoved(Object element, String name) {
            AttributeRemovedEvent message = new AttributeRemovedEvent();
            message.nodeId = DOM.this.mDocument.getNodeIdForElement(element);
            message.name = name;
            DOM.this.mPeerManager.sendNotificationToPeers("DOM.attributeRemoved", message);
        }

        @Override
        public void onInspectRequested(Object element) {
            Integer nodeId = DOM.this.mDocument.getNodeIdForElement(element);
            if (nodeId == null) {
                LogUtil.d("DocumentProvider.Listener.onInspectRequested() called for a non-mapped node: element=%s", element);
            } else {
                InspectNodeRequestedEvent message = new InspectNodeRequestedEvent();
                message.nodeId = nodeId;
                DOM.this.mPeerManager.sendNotificationToPeers("DOM.inspectNodeRequested", message);
            }
        }

        @Override
        public void onChildNodeRemoved(int parentNodeId, int nodeId) {
            ChildNodeRemovedEvent removedEvent = DOM.this.acquireChildNodeRemovedEvent();
            removedEvent.parentNodeId = parentNodeId;
            removedEvent.nodeId = nodeId;
            DOM.this.mPeerManager.sendNotificationToPeers("DOM.childNodeRemoved", removedEvent);
            DOM.this.releaseChildNodeRemovedEvent(removedEvent);
        }

        @Override
        public void onChildNodeInserted(DocumentView view, Object element, int parentNodeId, int previousNodeId, Accumulator<Object> insertedElements) {
            ChildNodeInsertedEvent insertedEvent = DOM.this.acquireChildNodeInsertedEvent();
            insertedEvent.parentNodeId = parentNodeId;
            insertedEvent.previousNodeId = previousNodeId;
            insertedEvent.node = DOM.this.createNodeForElement(element, view);
            insertedElements.store(element);
            DOM.this.mPeerManager.sendNotificationToPeers("DOM.childNodeInserted", insertedEvent);
            DOM.this.releaseChildNodeInsertedEvent(insertedEvent);
        }
    }
}

