/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.network;

import android.content.Context;
import android.util.Base64OutputStream;
import com.facebook.stetho.common.ExceptionUtil;
import com.facebook.stetho.common.LogRedirector;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinter;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterExecutorHolder;
import com.facebook.stetho.inspector.network.ResponseBodyData;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResponseBodyFileManager {
    private static final String TAG = "ResponseBodyFileManager";
    private static final String FILENAME_PREFIX = "network-response-body-";
    private static final int PRETTY_PRINT_TIMEOUT_SEC = 10;
    private final Context mContext;
    private final Map<String, AsyncPrettyPrinter> mRequestIdMap = Collections.synchronizedMap(new HashMap());

    public ResponseBodyFileManager(Context context) {
        this.mContext = context;
    }

    public void cleanupFiles() {
        for (File file : this.mContext.getFilesDir().listFiles()) {
            if (!file.getName().startsWith(FILENAME_PREFIX) || file.delete()) continue;
            LogRedirector.w(TAG, "Failed to delete " + file.getAbsolutePath());
        }
        LogRedirector.i(TAG, "Cleaned up temporary network files.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseBodyData readFile(String requestId) throws IOException {
        try (FileInputStream in = this.mContext.openFileInput(ResponseBodyFileManager.getFilename(requestId));){
            int firstByte = ((InputStream)in).read();
            if (firstByte == -1) {
                throw new EOFException("Failed to read base64Encode byte");
            }
            ResponseBodyData bodyData = new ResponseBodyData();
            bodyData.base64Encoded = firstByte != 0;
            AsyncPrettyPrinter asyncPrettyPrinter = this.mRequestIdMap.get(requestId);
            bodyData.data = asyncPrettyPrinter != null ? this.prettyPrintContentWithTimeOut(asyncPrettyPrinter, in) : Util.readAsUTF8(in);
            ResponseBodyData responseBodyData = bodyData;
            return responseBodyData;
        }
    }

    private String prettyPrintContentWithTimeOut(AsyncPrettyPrinter asyncPrettyPrinter, InputStream in) throws IOException {
        AsyncPrettyPrintingCallable prettyPrintingCallable = new AsyncPrettyPrintingCallable(in, asyncPrettyPrinter);
        ExecutorService executorService = AsyncPrettyPrinterExecutorHolder.getExecutorService();
        if (executorService == null) {
            return null;
        }
        Future<String> future = executorService.submit(prettyPrintingCallable);
        try {
            return Util.getUninterruptibly(future, 10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            return "Time out after 10 seconds of attempting to pretty print\n" + Util.readAsUTF8(in);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            ExceptionUtil.propagateIfInstanceOf(cause, IOException.class);
            throw ExceptionUtil.propagate(cause);
        }
    }

    public OutputStream openResponseBodyFile(String requestId, boolean base64Encode) throws IOException {
        FileOutputStream out = this.mContext.openFileOutput(ResponseBodyFileManager.getFilename(requestId), 0);
        ((OutputStream)out).write(base64Encode ? 1 : 0);
        if (base64Encode) {
            return new Base64OutputStream((OutputStream)out, 0);
        }
        return out;
    }

    private static String getFilename(String requestId) {
        return FILENAME_PREFIX + requestId;
    }

    public void associateAsyncPrettyPrinterWithId(String requestId, AsyncPrettyPrinter asyncPrettyPrinter) {
        if (this.mRequestIdMap.put(requestId, asyncPrettyPrinter) != null) {
            throw new IllegalArgumentException("cannot associate different pretty printers with the same request id: " + requestId);
        }
    }

    private class AsyncPrettyPrintingCallable
    implements Callable<String> {
        private final InputStream mInputStream;
        private final AsyncPrettyPrinter mAsyncPrettyPrinter;

        public AsyncPrettyPrintingCallable(InputStream in, AsyncPrettyPrinter asyncPrettyPrinter) {
            this.mInputStream = in;
            this.mAsyncPrettyPrinter = asyncPrettyPrinter;
        }

        @Override
        public String call() throws IOException {
            return this.prettyPrintContent(this.mInputStream, this.mAsyncPrettyPrinter);
        }

        private String prettyPrintContent(InputStream in, AsyncPrettyPrinter asyncPrettyPrinter) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            asyncPrettyPrinter.printTo(writer, in);
            writer.flush();
            return out.toString("UTF-8");
        }
    }
}

