/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.network;

import com.facebook.stetho.inspector.network.CountingOutputStream;
import com.facebook.stetho.inspector.network.GunzippingOutputStream;
import com.facebook.stetho.inspector.network.NetworkEventReporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.InflaterOutputStream;
import javax.annotation.Nullable;

public class RequestBodyHelper {
    private final NetworkEventReporter mEventReporter;
    private final String mRequestId;
    private ByteArrayOutputStream mDeflatedOutput;
    private CountingOutputStream mDeflatingOutput;

    public RequestBodyHelper(NetworkEventReporter eventReporter, String requestId) {
        this.mEventReporter = eventReporter;
        this.mRequestId = requestId;
    }

    public OutputStream createBodySink(@Nullable String contentEncoding) throws IOException {
        ByteArrayOutputStream deflatedOutput = new ByteArrayOutputStream();
        OutputStream deflatingOutput = "gzip".equals(contentEncoding) ? GunzippingOutputStream.create(deflatedOutput) : ("deflate".equals(contentEncoding) ? new InflaterOutputStream(deflatedOutput) : deflatedOutput);
        this.mDeflatingOutput = new CountingOutputStream(deflatingOutput);
        this.mDeflatedOutput = deflatedOutput;
        return this.mDeflatingOutput;
    }

    public byte[] getDisplayBody() {
        this.throwIfNoBody();
        return this.mDeflatedOutput.toByteArray();
    }

    public boolean hasBody() {
        return this.mDeflatedOutput != null;
    }

    public void reportDataSent() {
        this.throwIfNoBody();
        this.mEventReporter.dataSent(this.mRequestId, this.mDeflatedOutput.size(), (int)this.mDeflatingOutput.getCount());
    }

    private void throwIfNoBody() {
        if (!this.hasBody()) {
            throw new IllegalStateException("No body found; has createBodySink been called?");
        }
    }
}

