/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.network;

import android.content.Context;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeersRegisteredListener;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterExecutorHolder;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterInitializer;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterRegistry;
import com.facebook.stetho.inspector.network.ResponseBodyFileManager;
import javax.annotation.Nullable;

public class NetworkPeerManager
extends ChromePeerManager {
    private static NetworkPeerManager sInstance;
    private final ResponseBodyFileManager mResponseBodyFileManager;
    private AsyncPrettyPrinterInitializer mPrettyPrinterInitializer;
    private AsyncPrettyPrinterRegistry mAsyncPrettyPrinterRegistry;
    private final PeersRegisteredListener mTempFileCleanup = new PeersRegisteredListener(){

        @Override
        protected void onFirstPeerRegistered() {
            AsyncPrettyPrinterExecutorHolder.ensureInitialized();
            if (NetworkPeerManager.this.mAsyncPrettyPrinterRegistry == null && NetworkPeerManager.this.mPrettyPrinterInitializer != null) {
                NetworkPeerManager.this.mAsyncPrettyPrinterRegistry = new AsyncPrettyPrinterRegistry();
                NetworkPeerManager.this.mPrettyPrinterInitializer.populatePrettyPrinters(NetworkPeerManager.this.mAsyncPrettyPrinterRegistry);
            }
            NetworkPeerManager.this.mResponseBodyFileManager.cleanupFiles();
        }

        @Override
        protected void onLastPeerUnregistered() {
            NetworkPeerManager.this.mResponseBodyFileManager.cleanupFiles();
            AsyncPrettyPrinterExecutorHolder.shutdown();
        }
    };

    @Nullable
    public static synchronized NetworkPeerManager getInstanceOrNull() {
        return sInstance;
    }

    public static synchronized NetworkPeerManager getOrCreateInstance(Context context) {
        if (sInstance == null) {
            sInstance = new NetworkPeerManager(new ResponseBodyFileManager(context.getApplicationContext()));
        }
        return sInstance;
    }

    public NetworkPeerManager(ResponseBodyFileManager responseBodyFileManager) {
        this.mResponseBodyFileManager = responseBodyFileManager;
        this.setListener(this.mTempFileCleanup);
    }

    public ResponseBodyFileManager getResponseBodyFileManager() {
        return this.mResponseBodyFileManager;
    }

    @Nullable
    public AsyncPrettyPrinterRegistry getAsyncPrettyPrinterRegistry() {
        return this.mAsyncPrettyPrinterRegistry;
    }

    public void setPrettyPrinterInitializer(AsyncPrettyPrinterInitializer initializer) {
        Util.throwIfNotNull(this.mPrettyPrinterInitializer);
        this.mPrettyPrinterInitializer = Util.throwIfNull(initializer);
    }
}

