/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.network;

import android.os.SystemClock;
import com.facebook.stetho.common.Utf8Charset;
import com.facebook.stetho.inspector.console.CLog;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinter;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterFactory;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterRegistry;
import com.facebook.stetho.inspector.network.DecompressionHelper;
import com.facebook.stetho.inspector.network.NetworkEventReporter;
import com.facebook.stetho.inspector.network.NetworkPeerManager;
import com.facebook.stetho.inspector.network.ResourceTypeHelper;
import com.facebook.stetho.inspector.network.ResponseHandler;
import com.facebook.stetho.inspector.protocol.module.Console;
import com.facebook.stetho.inspector.protocol.module.Network;
import com.facebook.stetho.inspector.protocol.module.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkEventReporterImpl
implements NetworkEventReporter {
    @Nullable
    private ResourceTypeHelper mResourceTypeHelper;
    private static NetworkEventReporter sInstance;

    private NetworkEventReporterImpl() {
    }

    public static synchronized NetworkEventReporter get() {
        if (sInstance == null) {
            sInstance = new NetworkEventReporterImpl();
        }
        return sInstance;
    }

    @Override
    public boolean isEnabled() {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        return peerManager != null;
    }

    @Nullable
    private NetworkPeerManager getPeerManagerIfEnabled() {
        NetworkPeerManager peerManager = NetworkPeerManager.getInstanceOrNull();
        if (peerManager != null && peerManager.hasRegisteredPeers()) {
            return peerManager;
        }
        return null;
    }

    @Override
    public void requestWillBeSent(NetworkEventReporter.InspectorRequest request) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            Network.Request requestJSON = new Network.Request();
            requestJSON.url = request.url();
            requestJSON.method = request.method();
            requestJSON.headers = NetworkEventReporterImpl.formatHeadersAsJSON(request);
            requestJSON.postData = NetworkEventReporterImpl.readBodyAsString(peerManager, request);
            String requestFriendlyName = request.friendlyName();
            Integer requestPriority = request.friendlyNameExtra();
            Network.Initiator initiatorJSON = new Network.Initiator();
            initiatorJSON.type = Network.InitiatorType.SCRIPT;
            initiatorJSON.stackTrace = new ArrayList<Console.CallFrame>();
            initiatorJSON.stackTrace.add(new Console.CallFrame(requestFriendlyName, requestFriendlyName, requestPriority != null ? requestPriority : 0, 0));
            Network.RequestWillBeSentParams params = new Network.RequestWillBeSentParams();
            params.requestId = request.id();
            params.frameId = "1";
            params.loaderId = "1";
            params.documentURL = request.url();
            params.request = requestJSON;
            params.timestamp = (double)NetworkEventReporterImpl.stethoNow() / 1000.0;
            params.initiator = initiatorJSON;
            params.redirectResponse = null;
            params.type = Page.ResourceType.OTHER;
            peerManager.sendNotificationToPeers("Network.requestWillBeSent", params);
        }
    }

    @Nullable
    private static String readBodyAsString(NetworkPeerManager peerManager, NetworkEventReporter.InspectorRequest request) {
        try {
            byte[] body = request.body();
            if (body != null) {
                return new String(body, Utf8Charset.INSTANCE);
            }
        }
        catch (IOException | OutOfMemoryError e) {
            CLog.writeToConsole(peerManager, Console.MessageLevel.WARNING, Console.MessageSource.NETWORK, "Could not reproduce POST body: " + e);
        }
        return null;
    }

    @Override
    public void responseHeadersReceived(NetworkEventReporter.InspectorResponse response) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            Network.Response responseJSON = new Network.Response();
            responseJSON.url = response.url();
            responseJSON.status = response.statusCode();
            responseJSON.statusText = response.reasonPhrase();
            responseJSON.headers = NetworkEventReporterImpl.formatHeadersAsJSON(response);
            String contentType = this.getContentType(response);
            responseJSON.mimeType = contentType != null ? this.getResourceTypeHelper().stripContentExtras(contentType) : "application/octet-stream";
            responseJSON.connectionReused = response.connectionReused();
            responseJSON.connectionId = response.connectionId();
            responseJSON.fromDiskCache = response.fromDiskCache();
            Network.ResponseReceivedParams receivedParams = new Network.ResponseReceivedParams();
            receivedParams.requestId = response.requestId();
            receivedParams.frameId = "1";
            receivedParams.loaderId = "1";
            receivedParams.timestamp = (double)NetworkEventReporterImpl.stethoNow() / 1000.0;
            receivedParams.response = responseJSON;
            AsyncPrettyPrinter asyncPrettyPrinter = NetworkEventReporterImpl.initAsyncPrettyPrinterForResponse(response, peerManager);
            receivedParams.type = NetworkEventReporterImpl.determineResourceType(asyncPrettyPrinter, contentType, this.getResourceTypeHelper());
            peerManager.sendNotificationToPeers("Network.responseReceived", receivedParams);
        }
    }

    @Nullable
    private static AsyncPrettyPrinter initAsyncPrettyPrinterForResponse(NetworkEventReporter.InspectorResponse response, NetworkPeerManager peerManager) {
        AsyncPrettyPrinterRegistry registry = peerManager.getAsyncPrettyPrinterRegistry();
        AsyncPrettyPrinter asyncPrettyPrinter = NetworkEventReporterImpl.createPrettyPrinterForResponse(response, registry);
        if (asyncPrettyPrinter != null) {
            peerManager.getResponseBodyFileManager().associateAsyncPrettyPrinterWithId(response.requestId(), asyncPrettyPrinter);
        }
        return asyncPrettyPrinter;
    }

    private static Page.ResourceType determineResourceType(AsyncPrettyPrinter asyncPrettyPrinter, String contentType, ResourceTypeHelper resourceTypeHelper) {
        if (asyncPrettyPrinter != null) {
            return asyncPrettyPrinter.getPrettifiedType().getResourceType();
        }
        return contentType != null ? resourceTypeHelper.determineResourceType(contentType) : Page.ResourceType.OTHER;
    }

    @Nullable
    static AsyncPrettyPrinter createPrettyPrinterForResponse(NetworkEventReporter.InspectorResponse response, @Nullable AsyncPrettyPrinterRegistry registry) {
        if (registry != null) {
            int count = response.headerCount();
            for (int i = 0; i < count; ++i) {
                AsyncPrettyPrinterFactory factory = registry.lookup(response.headerName(i));
                if (factory == null) continue;
                AsyncPrettyPrinter asyncPrettyPrinter = factory.getInstance(response.headerName(i), response.headerValue(i));
                return asyncPrettyPrinter;
            }
        }
        return null;
    }

    @Override
    public InputStream interpretResponseStream(String requestId, @Nullable String contentType, @Nullable String contentEncoding, @Nullable InputStream availableInputStream, ResponseHandler responseHandler) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            if (availableInputStream == null) {
                responseHandler.onEOF();
                return null;
            }
            Page.ResourceType resourceType = contentType != null ? this.getResourceTypeHelper().determineResourceType(contentType) : null;
            boolean base64Encode = false;
            if (resourceType != null && resourceType == Page.ResourceType.IMAGE) {
                base64Encode = true;
            }
            try {
                OutputStream fileOutputStream = peerManager.getResponseBodyFileManager().openResponseBodyFile(requestId, base64Encode);
                return DecompressionHelper.teeInputWithDecompression(peerManager, requestId, availableInputStream, fileOutputStream, contentEncoding, responseHandler);
            }
            catch (IOException e) {
                CLog.writeToConsole(peerManager, Console.MessageLevel.ERROR, Console.MessageSource.NETWORK, "Error writing response body data for request #" + requestId);
            }
        }
        return availableInputStream;
    }

    @Override
    public void httpExchangeFailed(String requestId, String errorText) {
        this.loadingFailed(requestId, errorText);
    }

    @Override
    public void responseReadFinished(String requestId) {
        this.loadingFinished(requestId);
    }

    private void loadingFinished(String requestId) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            Network.LoadingFinishedParams finishedParams = new Network.LoadingFinishedParams();
            finishedParams.requestId = requestId;
            finishedParams.timestamp = (double)NetworkEventReporterImpl.stethoNow() / 1000.0;
            peerManager.sendNotificationToPeers("Network.loadingFinished", finishedParams);
        }
    }

    @Override
    public void responseReadFailed(String requestId, String errorText) {
        this.loadingFailed(requestId, errorText);
    }

    private void loadingFailed(String requestId, String errorText) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            Network.LoadingFailedParams failedParams = new Network.LoadingFailedParams();
            failedParams.requestId = requestId;
            failedParams.timestamp = (double)NetworkEventReporterImpl.stethoNow() / 1000.0;
            failedParams.errorText = errorText;
            failedParams.type = Page.ResourceType.OTHER;
            peerManager.sendNotificationToPeers("Network.loadingFailed", failedParams);
        }
    }

    @Override
    public void dataSent(String requestId, int dataLength, int encodedDataLength) {
        this.dataReceived(requestId, dataLength, encodedDataLength);
    }

    @Override
    public void dataReceived(String requestId, int dataLength, int encodedDataLength) {
        NetworkPeerManager peerManager = this.getPeerManagerIfEnabled();
        if (peerManager != null) {
            Network.DataReceivedParams dataReceivedParams = new Network.DataReceivedParams();
            dataReceivedParams.requestId = requestId;
            dataReceivedParams.timestamp = (double)NetworkEventReporterImpl.stethoNow() / 1000.0;
            dataReceivedParams.dataLength = dataLength;
            dataReceivedParams.encodedDataLength = encodedDataLength;
            peerManager.sendNotificationToPeers("Network.dataReceived", dataReceivedParams);
        }
    }

    @Nullable
    private String getContentType(NetworkEventReporter.InspectorHeaders headers) {
        return headers.firstHeaderValue("Content-Type");
    }

    private static JSONObject formatHeadersAsJSON(NetworkEventReporter.InspectorHeaders headers) {
        JSONObject json = new JSONObject();
        for (int i = 0; i < headers.headerCount(); ++i) {
            String name = headers.headerName(i);
            String value = headers.headerValue(i);
            try {
                if (json.has(name)) {
                    json.put(name, (Object)(json.getString(name) + "\n" + value));
                    continue;
                }
                json.put(name, (Object)value);
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }

    @Nonnull
    private ResourceTypeHelper getResourceTypeHelper() {
        if (this.mResourceTypeHelper == null) {
            this.mResourceTypeHelper = new ResourceTypeHelper();
        }
        return this.mResourceTypeHelper;
    }

    private static long stethoNow() {
        return SystemClock.elapsedRealtime();
    }
}

