/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.network;

import com.facebook.stetho.common.ExceptionUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinter;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterExecutorHolder;
import com.facebook.stetho.inspector.network.AsyncPrettyPrinterFactory;
import com.facebook.stetho.inspector.network.PrettyPrinterDisplayType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public abstract class DownloadingAsyncPrettyPrinterFactory
implements AsyncPrettyPrinterFactory {
    @Override
    public AsyncPrettyPrinter getInstance(String headerName, String headerValue) {
        final MatchResult result = this.matchAndParseHeader(headerName, headerValue);
        if (result == null) {
            return null;
        }
        String uri = result.getSchemaUri();
        URL schemaURL = DownloadingAsyncPrettyPrinterFactory.parseURL(uri);
        if (schemaURL == null) {
            return DownloadingAsyncPrettyPrinterFactory.getErrorAsyncPrettyPrinter(headerName, headerValue);
        }
        ExecutorService executorService = AsyncPrettyPrinterExecutorHolder.getExecutorService();
        if (executorService == null) {
            return null;
        }
        final Future<String> response = executorService.submit(new Request(schemaURL));
        return new AsyncPrettyPrinter(){

            @Override
            public void printTo(PrintWriter output, InputStream payload) throws IOException {
                try {
                    String schema;
                    try {
                        schema = (String)response.get();
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (IOException.class.isInstance(cause)) {
                            DownloadingAsyncPrettyPrinterFactory.doErrorPrint(output, payload, "Cannot successfully download schema: " + e.getMessage());
                            return;
                        }
                        throw e;
                    }
                    DownloadingAsyncPrettyPrinterFactory.this.doPrint(output, payload, schema);
                }
                catch (InterruptedException e) {
                    DownloadingAsyncPrettyPrinterFactory.doErrorPrint(output, payload, "Encountered spurious interrupt while downloading schema for pretty printing: " + e.getMessage());
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    throw ExceptionUtil.propagate(cause);
                }
            }

            @Override
            public PrettyPrinterDisplayType getPrettifiedType() {
                return result.getDisplayType();
            }
        };
    }

    @Nullable
    protected abstract MatchResult matchAndParseHeader(String var1, String var2);

    protected abstract void doPrint(PrintWriter var1, InputStream var2, String var3) throws IOException;

    @Nullable
    private static URL parseURL(String uri) {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static void doErrorPrint(PrintWriter output, InputStream payload, String errorMessage) throws IOException {
        output.print(errorMessage + "\n" + Util.readAsUTF8(payload));
    }

    private static AsyncPrettyPrinter getErrorAsyncPrettyPrinter(final String headerName, final String headerValue) {
        return new AsyncPrettyPrinter(){

            @Override
            public void printTo(PrintWriter output, InputStream payload) throws IOException {
                String errorMessage = "[Failed to parse header: " + headerName + " : " + headerValue + " ]";
                DownloadingAsyncPrettyPrinterFactory.doErrorPrint(output, payload, errorMessage);
            }

            @Override
            public PrettyPrinterDisplayType getPrettifiedType() {
                return PrettyPrinterDisplayType.TEXT;
            }
        };
    }

    private static class Request
    implements Callable<String> {
        private URL url;

        public Request(URL url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws IOException {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Got status code: " + statusCode + " while downloading " + "schema with url: " + this.url.toString());
            }
            try (InputStream urlStream = connection.getInputStream();){
                String string2 = Util.readAsUTF8(urlStream);
                return string2;
            }
        }
    }

    protected class MatchResult {
        private final String mSchemaUri;
        private final PrettyPrinterDisplayType mDisplayType;

        public MatchResult(String schemaUri, PrettyPrinterDisplayType displayType) {
            this.mSchemaUri = schemaUri;
            this.mDisplayType = displayType;
        }

        public String getSchemaUri() {
            return this.mSchemaUri;
        }

        public PrettyPrinterDisplayType getDisplayType() {
            return this.mDisplayType;
        }
    }
}

