/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.helper;

import com.facebook.stetho.inspector.helper.PeerRegistrationListener;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class PeersRegisteredListener
implements PeerRegistrationListener {
    private AtomicInteger mPeers = new AtomicInteger(0);

    @Override
    public final void onPeerRegistered(JsonRpcPeer peer) {
        if (this.mPeers.incrementAndGet() == 1) {
            this.onFirstPeerRegistered();
        }
        this.onPeerAdded(peer);
    }

    @Override
    public final void onPeerUnregistered(JsonRpcPeer peer) {
        if (this.mPeers.decrementAndGet() == 0) {
            this.onLastPeerUnregistered();
        }
        this.onPeerRemoved(peer);
    }

    protected void onPeerAdded(JsonRpcPeer peer) {
    }

    protected void onPeerRemoved(JsonRpcPeer peer) {
    }

    protected abstract void onFirstPeerRegistered();

    protected abstract void onLastPeerUnregistered();
}

