/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.helper;

import android.util.SparseArray;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class ObjectIdMapper {
    protected final Object mSync = new Object();
    @GuardedBy(value="mSync")
    private int mNextId = 1;
    @GuardedBy(value="mSync")
    private final Map<Object, Integer> mObjectToIdMap = new IdentityHashMap<Object, Integer>();
    @GuardedBy(value="mSync")
    private SparseArray<Object> mIdToObjectMap = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SparseArray<Object> idToObjectMap;
        Object object = this.mSync;
        synchronized (object) {
            idToObjectMap = this.mIdToObjectMap;
            this.mObjectToIdMap.clear();
            this.mIdToObjectMap = new SparseArray();
        }
        int size = idToObjectMap.size();
        for (int i = 0; i < size; ++i) {
            int id2 = idToObjectMap.keyAt(i);
            Object object2 = idToObjectMap.valueAt(i);
            this.onUnmapped(object2, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int id2) {
        Object object = this.mSync;
        synchronized (object) {
            return this.mIdToObjectMap.get(id2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObject(Object object) {
        Object object2 = this.mSync;
        synchronized (object2) {
            return this.mObjectToIdMap.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getObjectForId(int id2) {
        Object object = this.mSync;
        synchronized (object) {
            return this.mIdToObjectMap.get(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Integer getIdForObject(Object object) {
        Object object2 = this.mSync;
        synchronized (object2) {
            return this.mObjectToIdMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putObject(Object object) {
        Integer id2;
        Object object2 = this.mSync;
        synchronized (object2) {
            id2 = this.mObjectToIdMap.get(object);
            if (id2 != null) {
                return id2;
            }
            id2 = this.mNextId++;
            this.mObjectToIdMap.put(object, id2);
            this.mIdToObjectMap.put(id2.intValue(), object);
        }
        this.onMapped(object, id2);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object removeObjectById(int id2) {
        Object object;
        Object object2 = this.mSync;
        synchronized (object2) {
            object = this.mIdToObjectMap.get(id2);
            if (object == null) {
                return null;
            }
            this.mIdToObjectMap.remove(id2);
            this.mObjectToIdMap.remove(object);
        }
        this.onUnmapped(object, id2);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Integer removeObject(Object object) {
        Integer id2;
        Object object2 = this.mSync;
        synchronized (object2) {
            id2 = this.mObjectToIdMap.remove(object);
            if (id2 == null) {
                return null;
            }
            this.mIdToObjectMap.remove(id2.intValue());
        }
        this.onUnmapped(object, id2);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mObjectToIdMap.size();
        }
    }

    protected void onMapped(Object object, int id2) {
    }

    protected void onUnmapped(Object object, int id2) {
    }
}

