/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.helper;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.ViewDebug;

public class IntegerFormatter {
    private static IntegerFormatter cachedFormatter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntegerFormatter getInstance() {
        if (cachedFormatter != null) return cachedFormatter;
        Class<IntegerFormatter> clazz = IntegerFormatter.class;
        synchronized (IntegerFormatter.class) {
            if (cachedFormatter != null) return cachedFormatter;
            cachedFormatter = Build.VERSION.SDK_INT >= 21 ? new IntegerFormatterWithHex() : new IntegerFormatter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedFormatter;
        }
    }

    private IntegerFormatter() {
    }

    public String format(Integer integer2, @Nullable ViewDebug.ExportedProperty annotation) {
        return String.valueOf(integer2);
    }

    private static class IntegerFormatterWithHex
    extends IntegerFormatter {
        private IntegerFormatterWithHex() {
        }

        @Override
        @TargetApi(value=21)
        public String format(Integer integer2, @Nullable ViewDebug.ExportedProperty annotation) {
            if (annotation != null && annotation.formatToHexString()) {
                return "0x" + Integer.toHexString(integer2);
            }
            return super.format(integer2, annotation);
        }
    }
}

