/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.elements.android.ViewHighlightOverlays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

abstract class ViewHighlighter {
    public static ViewHighlighter newInstance() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new OverlayHighlighter();
        }
        LogUtil.w("Running on pre-JBMR2: View highlighting is not supported");
        return new NoopHighlighter();
    }

    protected ViewHighlighter() {
    }

    public abstract void clearHighlight();

    public abstract void setHighlightedView(View var1, int var2);

    @TargetApi(value=18)
    private static final class OverlayHighlighter
    extends ViewHighlighter {
        private final Handler mHandler;
        private final ViewHighlightOverlays mHighlightOverlays = ViewHighlightOverlays.newInstance();
        private View mHighlightedView;
        private AtomicReference<View> mViewToHighlight = new AtomicReference();
        private AtomicInteger mContentColor = new AtomicInteger();
        private final Runnable mHighlightViewOnUiThreadRunnable = new Runnable(){

            @Override
            public void run() {
                OverlayHighlighter.this.highlightViewOnUiThread();
            }
        };

        public OverlayHighlighter() {
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void clearHighlight() {
            this.setHighlightedViewImpl(null, 0);
        }

        @Override
        public void setHighlightedView(View view, int color2) {
            this.setHighlightedViewImpl(Util.throwIfNull(view), color2);
        }

        private void setHighlightedViewImpl(@Nullable View view, int color2) {
            this.mHandler.removeCallbacks(this.mHighlightViewOnUiThreadRunnable);
            this.mViewToHighlight.set(view);
            this.mContentColor.set(color2);
            this.mHandler.postDelayed(this.mHighlightViewOnUiThreadRunnable, 100L);
        }

        private void highlightViewOnUiThread() {
            View viewToHighlight = this.mViewToHighlight.getAndSet(null);
            if (viewToHighlight == this.mHighlightedView) {
                return;
            }
            if (this.mHighlightedView != null) {
                this.mHighlightOverlays.removeHighlight(this.mHighlightedView);
            }
            if (viewToHighlight != null) {
                this.mHighlightOverlays.highlightView(viewToHighlight, this.mContentColor.get());
                this.mHighlightedView = viewToHighlight;
            }
        }
    }

    private static final class NoopHighlighter
    extends ViewHighlighter {
        private NoopHighlighter() {
        }

        @Override
        public void clearHighlight() {
        }

        @Override
        public void setHighlightedView(View view, int color2) {
        }
    }
}

