/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.view.View;
import android.view.ViewDebug;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.StringUtil;
import com.facebook.stetho.common.android.ResourcesUtil;
import com.facebook.stetho.inspector.elements.AbstractChainedDescriptor;
import com.facebook.stetho.inspector.elements.AttributeAccumulator;
import com.facebook.stetho.inspector.elements.StyleAccumulator;
import com.facebook.stetho.inspector.elements.android.HighlightableDescriptor;
import com.facebook.stetho.inspector.elements.android.MethodInvoker;
import com.facebook.stetho.inspector.helper.IntegerFormatter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class ViewDescriptor
extends AbstractChainedDescriptor<View>
implements HighlightableDescriptor {
    private static final String ID_NAME = "id";
    private static final String NONE_VALUE = "(none)";
    private static final String NONE_MAPPING = "<no mapping>";
    private final MethodInvoker mMethodInvoker;
    @Nullable
    private Pattern mWordBoundaryPattern;
    @Nullable
    @GuardedBy(value="this")
    private volatile List<ViewCSSProperty> mViewProperties;

    private Pattern getWordBoundaryPattern() {
        if (this.mWordBoundaryPattern == null) {
            this.mWordBoundaryPattern = Pattern.compile("(?<=\\p{Lower})(?=\\p{Upper})");
        }
        return this.mWordBoundaryPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ViewCSSProperty> getViewProperties() {
        if (this.mViewProperties == null) {
            ViewDescriptor viewDescriptor = this;
            synchronized (viewDescriptor) {
                if (this.mViewProperties == null) {
                    ViewDebug.ExportedProperty annotation;
                    ArrayList<ViewCSSProperty> props = new ArrayList<ViewCSSProperty>();
                    for (Method method : View.class.getDeclaredMethods()) {
                        annotation = method.getAnnotation(ViewDebug.ExportedProperty.class);
                        if (annotation == null) continue;
                        props.add(new MethodBackedCSSProperty(method, this.convertViewPropertyNameToCSSName(method.getName()), annotation));
                    }
                    for (AccessibleObject accessibleObject : View.class.getDeclaredFields()) {
                        annotation = ((Field)accessibleObject).getAnnotation(ViewDebug.ExportedProperty.class);
                        if (annotation == null) continue;
                        props.add(new FieldBackedCSSProperty((Field)accessibleObject, this.convertViewPropertyNameToCSSName(((Field)accessibleObject).getName()), annotation));
                    }
                    this.mViewProperties = Collections.unmodifiableList(props);
                }
            }
        }
        return this.mViewProperties;
    }

    public ViewDescriptor() {
        this(new MethodInvoker());
    }

    public ViewDescriptor(MethodInvoker methodInvoker) {
        this.mMethodInvoker = methodInvoker;
    }

    @Override
    protected String onGetNodeName(View element) {
        String className = element.getClass().getName();
        return StringUtil.removePrefix(className, "android.view.", StringUtil.removePrefix(className, "android.widget."));
    }

    @Override
    protected void onGetAttributes(View element, AttributeAccumulator attributes) {
        String id2 = ViewDescriptor.getIdAttribute(element);
        if (id2 != null) {
            attributes.store(ID_NAME, id2);
        }
    }

    @Override
    protected void onSetAttributesAsText(View element, String text) {
        Map<String, String> attributeToValueMap = ViewDescriptor.parseSetAttributesAsTextArg(text);
        for (Map.Entry<String, String> entry : attributeToValueMap.entrySet()) {
            String methodName = "set" + ViewDescriptor.capitalize(entry.getKey());
            String propertyValue = entry.getValue();
            this.mMethodInvoker.invoke(element, methodName, propertyValue);
        }
    }

    @Nullable
    private static String getIdAttribute(View element) {
        int id2 = element.getId();
        if (id2 == -1) {
            return null;
        }
        return ResourcesUtil.getIdStringQuietly(element, element.getResources(), id2);
    }

    @Override
    public View getViewForHighlighting(Object element) {
        return (View)element;
    }

    @Override
    protected void onGetStyles(View element, StyleAccumulator styles) {
        List<ViewCSSProperty> properties = this.getViewProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            ViewCSSProperty property = properties.get(i);
            try {
                this.getStyleFromValue(element, property.getCSSName(), property.getValue(element), property.getAnnotation(), styles);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LogUtil.e(e, "failed to get style property " + property.getCSSName() + " of element= " + element.toString());
            }
        }
    }

    private static boolean canIntBeMappedToString(@Nullable ViewDebug.ExportedProperty annotation) {
        return annotation != null && annotation.mapping() != null && annotation.mapping().length > 0;
    }

    private static String mapIntToStringUsingAnnotation(int value, @Nullable ViewDebug.ExportedProperty annotation) {
        if (!ViewDescriptor.canIntBeMappedToString(annotation)) {
            throw new IllegalStateException("Cannot map using this annotation");
        }
        for (ViewDebug.IntToString map : annotation.mapping()) {
            if (map.from() != value) continue;
            return map.to();
        }
        return NONE_MAPPING;
    }

    private static boolean canFlagsBeMappedToString(@Nullable ViewDebug.ExportedProperty annotation) {
        return annotation != null && annotation.flagMapping() != null && annotation.flagMapping().length > 0;
    }

    private static String mapFlagsToStringUsingAnnotation(int value, @Nullable ViewDebug.ExportedProperty annotation) {
        if (!ViewDescriptor.canFlagsBeMappedToString(annotation)) {
            throw new IllegalStateException("Cannot map using this annotation");
        }
        StringBuilder stringBuilder = null;
        boolean atLeastOneFlag = false;
        for (ViewDebug.FlagToString flagToString : annotation.flagMapping()) {
            if (flagToString.outputIf() != ((value & flagToString.mask()) == flagToString.equals())) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (atLeastOneFlag) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(flagToString.name());
            atLeastOneFlag = true;
        }
        if (atLeastOneFlag) {
            return stringBuilder.toString();
        }
        return NONE_MAPPING;
    }

    private static boolean isDefaultValue(Float value) {
        return value.floatValue() == 0.0f;
    }

    private static boolean isDefaultValue(Integer value, @Nullable ViewDebug.ExportedProperty annotation) {
        if (ViewDescriptor.canFlagsBeMappedToString(annotation) || ViewDescriptor.canIntBeMappedToString(annotation)) {
            return false;
        }
        return value == 0;
    }

    private String convertViewPropertyNameToCSSName(String getterName) {
        String[] words = this.getWordBoundaryPattern().split(getterName);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (words[i].equals("get") || words[i].equals("m")) continue;
            result.append(words[i].toLowerCase());
            if (i >= words.length - 1) continue;
            result.append('-');
        }
        return result.toString();
    }

    private void getStyleFromValue(View element, String name, Object value, @Nullable ViewDebug.ExportedProperty annotation, StyleAccumulator styles) {
        if (name.equals(ID_NAME)) {
            this.getIdStyle(element, styles);
        } else if (value instanceof Integer) {
            this.getStyleFromInteger(name, (Integer)value, annotation, styles);
        } else if (value instanceof Float) {
            this.getStyleFromFloat(name, (Float)value, annotation, styles);
        }
    }

    private void getIdStyle(View element, StyleAccumulator styles) {
        String id2 = ViewDescriptor.getIdAttribute(element);
        if (id2 == null) {
            styles.store(ID_NAME, NONE_VALUE, false);
        } else {
            styles.store(ID_NAME, id2, false);
        }
    }

    private void getStyleFromInteger(String name, Integer value, @Nullable ViewDebug.ExportedProperty annotation, StyleAccumulator styles) {
        String intValueStr = IntegerFormatter.getInstance().format(value, annotation);
        if (ViewDescriptor.canIntBeMappedToString(annotation)) {
            styles.store(name, intValueStr + " (" + ViewDescriptor.mapIntToStringUsingAnnotation(value, annotation) + ")", false);
        } else if (ViewDescriptor.canFlagsBeMappedToString(annotation)) {
            styles.store(name, intValueStr + " (" + ViewDescriptor.mapFlagsToStringUsingAnnotation(value, annotation) + ")", false);
        } else {
            styles.store(name, intValueStr, ViewDescriptor.isDefaultValue(value, annotation));
        }
    }

    private void getStyleFromFloat(String name, Float value, @Nullable ViewDebug.ExportedProperty annotation, StyleAccumulator styles) {
        styles.store(name, String.valueOf(value), ViewDescriptor.isDefaultValue(value));
    }

    private static String capitalize(String str) {
        if (str == null || str.length() == 0 || Character.isTitleCase(str.charAt(0))) {
            return str;
        }
        StringBuilder buffer = new StringBuilder(str);
        buffer.setCharAt(0, Character.toTitleCase(buffer.charAt(0)));
        return buffer.toString();
    }

    private abstract class ViewCSSProperty {
        private final String mCSSName;
        private final ViewDebug.ExportedProperty mAnnotation;

        public ViewCSSProperty(@Nullable String cssName, ViewDebug.ExportedProperty annotation) {
            this.mCSSName = cssName;
            this.mAnnotation = annotation;
        }

        public final String getCSSName() {
            return this.mCSSName;
        }

        public abstract Object getValue(View var1) throws InvocationTargetException, IllegalAccessException;

        @Nullable
        public final ViewDebug.ExportedProperty getAnnotation() {
            return this.mAnnotation;
        }
    }

    private final class MethodBackedCSSProperty
    extends ViewCSSProperty {
        private final Method mMethod;

        public MethodBackedCSSProperty(Method method, @Nullable String cssName, ViewDebug.ExportedProperty annotation) {
            super(cssName, annotation);
            this.mMethod = method;
            this.mMethod.setAccessible(true);
        }

        @Override
        public Object getValue(View view) throws InvocationTargetException, IllegalAccessException {
            return this.mMethod.invoke((Object)view, new Object[0]);
        }
    }

    private final class FieldBackedCSSProperty
    extends ViewCSSProperty {
        private final Field mField;

        public FieldBackedCSSProperty(Field field, @Nullable String cssName, ViewDebug.ExportedProperty annotation) {
            super(cssName, annotation);
            this.mField = field;
            this.mField.setAccessible(true);
        }

        @Override
        public Object getValue(View view) throws InvocationTargetException, IllegalAccessException {
            return this.mField.get(view);
        }
    }
}

