/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class MethodInvoker {
    private static final List<TypedMethodInvoker<?>> invokers = Arrays.asList(new StringMethodInvoker(), new CharSequenceMethodInvoker(), new IntegerMethodInvoker(), new FloatMethodInvoker(), new BooleanMethodInvoker());

    public void invoke(Object receiver, String methodName, String argument) {
        Util.throwIfNull(receiver, methodName, argument);
        int size = invokers.size();
        for (int i = 0; i < size; ++i) {
            TypedMethodInvoker<?> invoker = invokers.get(i);
            if (!invoker.invoke(receiver, methodName, argument)) continue;
            return;
        }
        LogUtil.w("Method with name " + methodName + " not found for any of the MethodInvoker supported argument types.");
    }

    private static class BooleanMethodInvoker
    extends TypedMethodInvoker<Boolean> {
        BooleanMethodInvoker() {
            super(Boolean.TYPE);
        }

        @Override
        Boolean convertArgument(String argument) {
            return Boolean.parseBoolean(argument);
        }
    }

    private static class FloatMethodInvoker
    extends TypedMethodInvoker<Float> {
        FloatMethodInvoker() {
            super(Float.TYPE);
        }

        @Override
        Float convertArgument(String argument) {
            return Float.valueOf(Float.parseFloat(argument));
        }
    }

    private static class IntegerMethodInvoker
    extends TypedMethodInvoker<Integer> {
        IntegerMethodInvoker() {
            super(Integer.TYPE);
        }

        @Override
        Integer convertArgument(String argument) {
            return Integer.parseInt(argument);
        }
    }

    private static class CharSequenceMethodInvoker
    extends TypedMethodInvoker<CharSequence> {
        CharSequenceMethodInvoker() {
            super(CharSequence.class);
        }

        @Override
        CharSequence convertArgument(String argument) {
            return argument;
        }
    }

    private static class StringMethodInvoker
    extends TypedMethodInvoker<String> {
        StringMethodInvoker() {
            super(String.class);
        }

        @Override
        String convertArgument(String argument) {
            return argument;
        }
    }

    private static abstract class TypedMethodInvoker<T> {
        private final Class<T> mArgType;

        TypedMethodInvoker(Class<T> argType) {
            this.mArgType = argType;
        }

        boolean invoke(Object receiver, String methodName, String argument) {
            try {
                Method method = receiver.getClass().getMethod(methodName, this.mArgType);
                method.invoke(receiver, this.convertArgument(argument));
                return true;
            }
            catch (NoSuchMethodException method) {
            }
            catch (InvocationTargetException e) {
                LogUtil.w("InvocationTargetException: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                LogUtil.w("IllegalAccessException: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LogUtil.w("IllegalArgumentException: " + e.getMessage());
            }
            return false;
        }

        abstract T convertArgument(String var1);
    }
}

