/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.view.View;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.android.FragmentAccessor;
import com.facebook.stetho.common.android.FragmentCompat;
import com.facebook.stetho.common.android.ResourcesUtil;
import com.facebook.stetho.inspector.elements.AbstractChainedDescriptor;
import com.facebook.stetho.inspector.elements.AttributeAccumulator;
import com.facebook.stetho.inspector.elements.DescriptorMap;
import com.facebook.stetho.inspector.elements.android.HighlightableDescriptor;
import javax.annotation.Nullable;

final class FragmentDescriptor
extends AbstractChainedDescriptor<Object>
implements HighlightableDescriptor {
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String TAG_ATTRIBUTE_NAME = "tag";
    private final FragmentAccessor mAccessor;

    public static DescriptorMap register(DescriptorMap map) {
        FragmentDescriptor.maybeRegister(map, FragmentCompat.getSupportLibInstance());
        FragmentDescriptor.maybeRegister(map, FragmentCompat.getFrameworkInstance());
        return map;
    }

    private static void maybeRegister(DescriptorMap map, @Nullable FragmentCompat compat) {
        if (compat != null) {
            Class fragmentClass = compat.getFragmentClass();
            LogUtil.d("Adding support for %s", fragmentClass.getName());
            map.register(fragmentClass, new FragmentDescriptor(compat));
        }
    }

    private FragmentDescriptor(FragmentCompat compat) {
        this.mAccessor = compat.forFragment();
    }

    @Override
    protected void onGetAttributes(Object element, AttributeAccumulator attributes) {
        String tag;
        int id2 = this.mAccessor.getId(element);
        if (id2 != 0) {
            String value = ResourcesUtil.getIdStringQuietly(element, this.mAccessor.getResources(element), id2);
            attributes.store(ID_ATTRIBUTE_NAME, value);
        }
        if ((tag = this.mAccessor.getTag(element)) != null && tag.length() > 0) {
            attributes.store(TAG_ATTRIBUTE_NAME, tag);
        }
    }

    @Override
    protected void onGetChildren(Object element, Accumulator<Object> children) {
        View view = this.mAccessor.getView(element);
        if (view != null) {
            children.store(view);
        }
    }

    @Override
    public View getViewForHighlighting(Object element) {
        return this.mAccessor.getView(element);
    }
}

