/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.app.Dialog;
import android.view.View;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.common.android.DialogFragmentAccessor;
import com.facebook.stetho.common.android.FragmentCompat;
import com.facebook.stetho.inspector.elements.AttributeAccumulator;
import com.facebook.stetho.inspector.elements.ChainedDescriptor;
import com.facebook.stetho.inspector.elements.Descriptor;
import com.facebook.stetho.inspector.elements.DescriptorMap;
import com.facebook.stetho.inspector.elements.NodeType;
import com.facebook.stetho.inspector.elements.StyleAccumulator;
import com.facebook.stetho.inspector.elements.android.AndroidDescriptorHost;
import com.facebook.stetho.inspector.elements.android.HighlightableDescriptor;
import javax.annotation.Nullable;

final class DialogFragmentDescriptor
extends Descriptor
implements ChainedDescriptor,
HighlightableDescriptor {
    private final DialogFragmentAccessor mAccessor;
    private Descriptor mSuper;

    public static DescriptorMap register(DescriptorMap map) {
        DialogFragmentDescriptor.maybeRegister(map, FragmentCompat.getSupportLibInstance());
        DialogFragmentDescriptor.maybeRegister(map, FragmentCompat.getFrameworkInstance());
        return map;
    }

    private static void maybeRegister(DescriptorMap map, @Nullable FragmentCompat compat) {
        if (compat != null) {
            Class dialogFragmentClass = compat.getDialogFragmentClass();
            LogUtil.d("Adding support for %s", dialogFragmentClass);
            map.register(dialogFragmentClass, new DialogFragmentDescriptor(compat));
        }
    }

    private DialogFragmentDescriptor(FragmentCompat compat) {
        this.mAccessor = compat.forDialogFragment();
    }

    @Override
    public void setSuper(Descriptor superDescriptor) {
        Util.throwIfNull(superDescriptor);
        if (superDescriptor != this.mSuper) {
            if (this.mSuper != null) {
                throw new IllegalStateException();
            }
            this.mSuper = superDescriptor;
        }
    }

    @Override
    public void hook(Object element) {
        this.mSuper.hook(element);
    }

    @Override
    public void unhook(Object element) {
        this.mSuper.unhook(element);
    }

    @Override
    public NodeType getNodeType(Object element) {
        return this.mSuper.getNodeType(element);
    }

    @Override
    public String getNodeName(Object element) {
        return this.mSuper.getNodeName(element);
    }

    @Override
    public String getLocalName(Object element) {
        return this.mSuper.getLocalName(element);
    }

    @Override
    @Nullable
    public String getNodeValue(Object element) {
        return this.mSuper.getNodeValue(element);
    }

    @Override
    public void getChildren(Object element, Accumulator<Object> children) {
        children.store(this.mAccessor.getDialog(element));
    }

    @Override
    public void getAttributes(Object element, AttributeAccumulator attributes) {
        this.mSuper.getAttributes(element, attributes);
    }

    @Override
    public void setAttributesAsText(Object element, String text) {
        this.mSuper.setAttributesAsText(element, text);
    }

    @Override
    @Nullable
    public View getViewForHighlighting(Object element) {
        Descriptor.Host host = this.getHost();
        if (host instanceof AndroidDescriptorHost) {
            Dialog dialog = this.mAccessor.getDialog(element);
            return ((AndroidDescriptorHost)host).getHighlightingView(dialog);
        }
        return null;
    }

    @Override
    public void getStyles(Object element, StyleAccumulator styles) {
    }
}

