/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.app.Activity;
import android.app.Application;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.inspector.elements.AbstractChainedDescriptor;
import com.facebook.stetho.inspector.elements.NodeType;
import com.facebook.stetho.inspector.elements.android.ActivityTracker;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

final class ApplicationDescriptor
extends AbstractChainedDescriptor<Application> {
    private final Map<Application, ElementContext> mElementToContextMap = Collections.synchronizedMap(new IdentityHashMap());
    private final ActivityTracker mActivityTracker = ActivityTracker.get();

    ApplicationDescriptor() {
    }

    private ElementContext getContext(Application element) {
        return this.mElementToContextMap.get(element);
    }

    @Override
    protected void onHook(Application element) {
        ElementContext context = new ElementContext();
        context.hook(element);
        this.mElementToContextMap.put(element, context);
    }

    @Override
    protected void onUnhook(Application element) {
        ElementContext context = this.mElementToContextMap.remove(element);
        context.unhook();
    }

    @Override
    protected NodeType onGetNodeType(Application element) {
        return NodeType.ELEMENT_NODE;
    }

    @Override
    protected void onGetChildren(Application element, Accumulator<Object> children) {
        ElementContext context = this.getContext(element);
        List<Activity> activities = context.getActivitiesList();
        for (int i = activities.size() - 1; i >= 0; --i) {
            children.store(activities.get(i));
        }
    }

    private class ElementContext {
        private Application mElement;
        private final ActivityTracker.Listener mListener = new ActivityTracker.Listener(){

            @Override
            public void onActivityAdded(Activity activity) {
            }

            @Override
            public void onActivityRemoved(Activity activity) {
            }
        };

        public void hook(Application element) {
            this.mElement = element;
            ApplicationDescriptor.this.mActivityTracker.registerListener(this.mListener);
        }

        public void unhook() {
            ApplicationDescriptor.this.mActivityTracker.unregisterListener(this.mListener);
            this.mElement = null;
        }

        public List<Activity> getActivitiesList() {
            return ApplicationDescriptor.this.mActivityTracker.getActivitiesView();
        }
    }
}

